/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.transform.func;

import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.logs.HttpLog;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RetryExceptionFunc
implements Function<Observable<? extends Throwable>, Observable<?>> {
    private int count = 0;
    private long delay = 500L;
    private long increaseDelay = 0L;

    public RetryExceptionFunc() {
    }

    public RetryExceptionFunc(int count, long delay) {
        this.count = count;
        this.delay = delay;
    }

    public RetryExceptionFunc(int count, long delay, long increaseDelay) {
        this.count = count;
        this.delay = delay;
        this.increaseDelay = increaseDelay;
    }

    public Observable<?> apply(Observable<? extends Throwable> observable) throws Exception {
        return observable.zipWith((ObservableSource)Observable.range((int)1, (int)(this.count + 1)), (BiFunction)new BiFunction<Throwable, Integer, Wrapper>(){

            public Wrapper apply(@NonNull Throwable throwable, @NonNull Integer integer) throws Exception {
                return new Wrapper(throwable, integer);
            }
        }).flatMap(new Function<Wrapper, ObservableSource<?>>(){

            public ObservableSource<?> apply(@NonNull Wrapper wrapper) throws Exception {
                if (wrapper.index > 1) {
                    HttpLog.i("\u91cd\u8bd5\u6b21\u6570\uff1a" + wrapper.index);
                }
                int errCode = 0;
                if (wrapper.throwable instanceof ApiException) {
                    ApiException exception = (ApiException)wrapper.throwable;
                    errCode = exception.getCode();
                }
                if ((wrapper.throwable instanceof ConnectException || wrapper.throwable instanceof SocketTimeoutException || errCode == 5002 || errCode == 5005 || wrapper.throwable instanceof SocketTimeoutException || wrapper.throwable instanceof TimeoutException) && wrapper.index < RetryExceptionFunc.this.count + 1) {
                    return Observable.timer((long)(RetryExceptionFunc.this.delay + (long)(wrapper.index - 1) * RetryExceptionFunc.this.increaseDelay), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)wrapper.throwable);
            }
        });
    }

    private class Wrapper {
        private int index;
        private Throwable throwable;

        public Wrapper(Throwable throwable, int index) {
            this.index = index;
            this.throwable = throwable;
        }
    }
}

