/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.transform;

import com.xuexiang.xhttp2.model.SchedulerType;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

public class HttpSchedulersTransformer<T>
implements ObservableTransformer<T, T> {
    private SchedulerType mSchedulerType;

    public HttpSchedulersTransformer(boolean isSyncRequest, boolean isOnMainThread) {
        this.mSchedulerType = this.getSchedulerType(isSyncRequest, isOnMainThread);
    }

    public HttpSchedulersTransformer(SchedulerType schedulerType) {
        this.mSchedulerType = schedulerType;
    }

    private SchedulerType getSchedulerType(boolean isSyncRequest, boolean isOnMainThread) {
        if (isSyncRequest) {
            if (isOnMainThread) {
                return SchedulerType._main;
            }
            return SchedulerType._io;
        }
        if (isOnMainThread) {
            return SchedulerType._io_main;
        }
        return SchedulerType._io_io;
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        switch (this.mSchedulerType) {
            case _main: {
                return upstream.observeOn(AndroidSchedulers.mainThread());
            }
            case _io: {
                return upstream;
            }
            case _io_main: {
                return upstream.subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            }
            case _io_io: {
                return upstream.subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io());
            }
        }
        return upstream;
    }
}

