/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.request;

import com.xuexiang.xhttp2.cache.model.CacheResult;
import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.callback.CallBackProxy;
import com.xuexiang.xhttp2.model.ApiResult;
import com.xuexiang.xhttp2.request.BaseRequest;
import com.xuexiang.xhttp2.subsciber.CallBackSubscriber;
import com.xuexiang.xhttp2.transform.HandleErrTransformer;
import com.xuexiang.xhttp2.transform.HttpResultTransformer;
import com.xuexiang.xhttp2.transform.HttpSchedulersTransformer;
import com.xuexiang.xhttp2.transform.func.CacheResultFunc;
import com.xuexiang.xhttp2.transform.func.RetryExceptionFunc;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import okhttp3.ResponseBody;

public class CustomRequest
extends BaseRequest<CustomRequest> {
    public CustomRequest() {
        super("");
    }

    @Override
    public CustomRequest build() {
        return (CustomRequest)super.build();
    }

    public <T> T create(Class<T> service) {
        this.checkValidate();
        return (T)this.mRetrofit.create(service);
    }

    private void checkValidate() {
        Utils.checkNotNull(this.mRetrofit, "\u8bf7\u5148\u5728\u8c03\u7528build()\u624d\u80fd\u4f7f\u7528");
    }

    public <T> Observable<T> apiCall(Observable<? extends ApiResult<T>> observable) {
        this.checkValidate();
        return observable.compose(new HttpResultTransformer()).compose(new HttpSchedulersTransformer(this.mIsSyncRequest, this.mIsOnMainThread)).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay));
    }

    public <T> Disposable apiCall(Observable observable, CallBack<T> callBack) {
        return this.call(observable, new CallBackProxy<ApiResult<T>, T>(callBack){});
    }

    public <T> Observable<T> call(Observable<T> observable) {
        this.checkValidate();
        return observable.compose(new HandleErrTransformer()).compose(new HttpSchedulersTransformer(this.mIsSyncRequest, this.mIsOnMainThread)).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay));
    }

    public <T> void call(Observable<T> observable, CallBack<T> callBack) {
        this.call((Observable)observable, (Observer)new CallBackSubscriber<T>(callBack));
    }

    public <R> void call(Observable observable, Observer<R> subscriber) {
        this.call(observable).subscribe(subscriber);
    }

    public <T> Disposable call(Observable<T> observable, CallBackProxy<? extends ApiResult<T>, T> proxy) {
        Observable<CacheResult<T>> cacheObservable = this.build().toObservable(observable, proxy);
        if (CacheResult.class != proxy.getRawType()) {
            return (Disposable)cacheObservable.compose(new ObservableTransformer<CacheResult<T>, T>(){

                public ObservableSource<T> apply(@NonNull Observable<CacheResult<T>> upstream) {
                    return upstream.map(new CacheResultFunc());
                }
            }).subscribeWith(new CallBackSubscriber(proxy.getCallBack()));
        }
        return (Disposable)cacheObservable.subscribeWith(new CallBackSubscriber(proxy.getCallBack()));
    }

    @Override
    protected <T> Observable<CacheResult<T>> toObservable(Observable observable, CallBackProxy<? extends ApiResult<T>, T> proxy) {
        this.checkValidate();
        return observable.compose(new HttpResultTransformer()).compose(new HttpSchedulersTransformer(this.mIsSyncRequest, this.mIsOnMainThread)).compose(this.mRxCache.transformer(this.mCacheMode, proxy.getCallBack().getType())).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay));
    }

    @Override
    protected Observable<ResponseBody> generateRequest() {
        return null;
    }
}

