/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.request;

import com.xuexiang.xhttp2.callback.impl.IProgressResponseCallBack;
import com.xuexiang.xhttp2.model.HttpParams;
import com.xuexiang.xhttp2.request.BaseRequest;
import com.xuexiang.xhttp2.request.body.UploadProgressRequestBody;
import com.xuexiang.xhttp2.utils.RequestBodyUtils;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.http.Body;

public abstract class BaseBodyRequest<R extends BaseBodyRequest>
extends BaseRequest<R> {
    protected String mString;
    protected MediaType mMediaType;
    protected String mJson;
    protected byte[] mBytes;
    protected Object mObject;
    protected RequestBody mRequestBody;
    private UploadType mUploadType = UploadType.PART;

    public BaseBodyRequest(String url) {
        super(url);
    }

    public R requestBody(RequestBody requestBody) {
        this.mRequestBody = requestBody;
        return (R)this;
    }

    public R upString(String string) {
        this.mString = string;
        this.mMediaType = MediaType.parse((String)"text/plain");
        return (R)this;
    }

    public R upString(String string, String mediaType) {
        this.mString = string;
        Utils.checkNotNull(mediaType, "MediaType == null");
        this.mMediaType = MediaType.parse((String)mediaType);
        return (R)this;
    }

    public R upObject(@Body Object object) {
        this.mObject = object;
        return (R)this;
    }

    public R upJson(String json) {
        this.mJson = json;
        return (R)this;
    }

    public R upBytes(byte[] bs) {
        this.mBytes = bs;
        return (R)this;
    }

    public R uploadFile(String key, File file, IProgressResponseCallBack responseCallBack) {
        this.mParams.put(key, file, responseCallBack);
        return (R)this;
    }

    public R uploadFile(String key, File file, String fileName, IProgressResponseCallBack responseCallBack) {
        this.mParams.put(key, file, fileName, responseCallBack);
        return (R)this;
    }

    public R uploadFile(String key, InputStream stream, String fileName, IProgressResponseCallBack responseCallBack) {
        this.mParams.put(key, stream, fileName, responseCallBack);
        return (R)this;
    }

    public R uploadFile(String key, byte[] bytes, String fileName, IProgressResponseCallBack responseCallBack) {
        this.mParams.put(key, bytes, fileName, responseCallBack);
        return (R)this;
    }

    public R uploadFiles(String key, List<File> files, IProgressResponseCallBack responseCallBack) {
        this.mParams.putFileParams(key, files, responseCallBack);
        return (R)this;
    }

    public <T> R uploadType(UploadType uploadtype) {
        this.mUploadType = uploadtype;
        return (R)this;
    }

    @Override
    protected Observable<ResponseBody> generateRequest() {
        if (this.mRequestBody != null) {
            return this.mApiManager.postBody(this.getUrl(), this.mRequestBody);
        }
        if (this.mJson != null) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.mJson);
            return this.mApiManager.postJson(this.getUrl(), body);
        }
        if (this.mObject != null) {
            return this.mApiManager.postBody(this.getUrl(), this.mObject);
        }
        if (this.mString != null) {
            RequestBody body = RequestBody.create((MediaType)this.mMediaType, (String)this.mString);
            return this.mApiManager.postBody(this.getUrl(), body);
        }
        if (this.mBytes != null) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])this.mBytes);
            return this.mApiManager.postBody(this.getUrl(), body);
        }
        if (this.mParams.fileParamsMap.isEmpty()) {
            return this.mApiManager.post(this.getUrl(), this.mParams.urlParamsMap);
        }
        if (this.mUploadType == UploadType.PART) {
            return this.uploadFilesWithParts();
        }
        return this.uploadFilesWithBodys();
    }

    protected Observable<ResponseBody> uploadFilesWithParts() {
        ArrayList<MultipartBody.Part> parts = new ArrayList<MultipartBody.Part>();
        for (Map.Entry<String, Object> entry : this.mParams.urlParamsMap.entrySet()) {
            parts.add(MultipartBody.Part.createFormData((String)entry.getKey(), (String)String.valueOf(entry.getValue())));
        }
        for (Map.Entry<String, Object> entry : this.mParams.fileParamsMap.entrySet()) {
            List fileValues = (List)entry.getValue();
            for (HttpParams.FileWrapper fileWrapper : fileValues) {
                MultipartBody.Part part = this.addFile(entry.getKey(), fileWrapper);
                parts.add(part);
            }
        }
        return this.mApiManager.uploadFiles(this.getUrl(), parts);
    }

    protected Observable<ResponseBody> uploadFilesWithBodys() {
        HashMap<String, RequestBody> bodyMap = new HashMap<String, RequestBody>();
        for (Map.Entry<String, Object> entry : this.mParams.urlParamsMap.entrySet()) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)String.valueOf(entry.getValue()));
            bodyMap.put(entry.getKey(), body);
        }
        for (Map.Entry<String, Object> entry : this.mParams.fileParamsMap.entrySet()) {
            List fileValues = (List)entry.getValue();
            for (HttpParams.FileWrapper fileWrapper : fileValues) {
                RequestBody requestBody = this.getRequestBody(fileWrapper);
                UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, fileWrapper.responseCallBack);
                bodyMap.put(entry.getKey(), uploadProgressRequestBody);
            }
        }
        return this.mApiManager.uploadFiles(this.getUrl(), bodyMap);
    }

    private MultipartBody.Part addFile(String key, HttpParams.FileWrapper fileWrapper) {
        RequestBody requestBody = this.getRequestBody(fileWrapper);
        Utils.checkNotNull(requestBody, "requestBody==null fileWrapper.file must is File/InputStream/byte[]");
        if (fileWrapper.responseCallBack != null) {
            UploadProgressRequestBody uploadProgressRequestBody = new UploadProgressRequestBody(requestBody, fileWrapper.responseCallBack);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)fileWrapper.fileName, (RequestBody)uploadProgressRequestBody);
            return part;
        }
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)key, (String)fileWrapper.fileName, (RequestBody)requestBody);
        return part;
    }

    private RequestBody getRequestBody(HttpParams.FileWrapper fileWrapper) {
        RequestBody requestBody = null;
        if (fileWrapper.file instanceof File) {
            requestBody = RequestBody.create((MediaType)fileWrapper.contentType, (File)((File)fileWrapper.file));
        } else if (fileWrapper.file instanceof InputStream) {
            requestBody = RequestBodyUtils.create(fileWrapper.contentType, (InputStream)fileWrapper.file);
        } else if (fileWrapper.file instanceof byte[]) {
            requestBody = RequestBody.create((MediaType)fileWrapper.contentType, (byte[])((byte[])fileWrapper.file));
        }
        return requestBody;
    }

    public static enum UploadType {
        PART,
        BODY;

    }
}

