/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.interceptor;

import android.content.Context;
import android.text.TextUtils;
import com.xuexiang.xhttp2.logs.HttpLog;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class CacheInterceptor
implements Interceptor {
    protected Context context;
    protected String cacheControlValue_Offline;
    protected String cacheControlValue_Online;
    protected static final int maxStale = 259200;
    protected static final int maxStaleOnline = 60;

    public CacheInterceptor(Context context) {
        this(context, String.format("max-age=%d", 60));
    }

    public CacheInterceptor(Context context, String cacheControlValue) {
        this(context, cacheControlValue, String.format("max-age=%d", 259200));
    }

    public CacheInterceptor(Context context, String cacheControlValueOffline, String cacheControlValueOnline) {
        this.context = context;
        this.cacheControlValue_Offline = cacheControlValueOffline;
        this.cacheControlValue_Online = cacheControlValueOnline;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response originalResponse = chain.proceed(chain.request());
        String cacheControl = originalResponse.header("Cache-Control");
        HttpLog.e("60s load cache:" + cacheControl);
        if (TextUtils.isEmpty((CharSequence)cacheControl) || cacheControl.contains("no-store") || cacheControl.contains("no-cache") || cacheControl.contains("must-revalidate") || cacheControl.contains("max-age") || cacheControl.contains("max-stale")) {
            return originalResponse.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, max-age=259200").build();
        }
        return originalResponse;
    }
}

