/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.interceptor;

import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.utils.HttpUtils;
import com.xuexiang.xhttp2.utils.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BaseDynamicInterceptor<R extends BaseDynamicInterceptor>
implements Interceptor {
    private HttpUrl mHttpUrl;
    private boolean mIsSign = false;
    private boolean mTimeStamp = false;
    private boolean mAccessToken = false;

    public boolean isSign() {
        return this.mIsSign;
    }

    public R sign(boolean sign) {
        this.mIsSign = sign;
        return (R)this;
    }

    public boolean isTimeStamp() {
        return this.mTimeStamp;
    }

    public R timeStamp(boolean timeStamp) {
        this.mTimeStamp = timeStamp;
        return (R)this;
    }

    public R accessToken(boolean accessToken) {
        this.mAccessToken = accessToken;
        return (R)this;
    }

    public boolean isAccessToken() {
        return this.mAccessToken;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.method().equals("GET")) {
            this.mHttpUrl = HttpUrl.parse((String)HttpUtils.parseUrl(request.url().toString()));
            request = this.addGetParamsSign(request);
        } else if (request.method().equals("POST")) {
            this.mHttpUrl = request.url();
            request = this.addPostParamsSign(request);
        }
        return chain.proceed(request);
    }

    public HttpUrl getHttpUrl() {
        return this.mHttpUrl;
    }

    private Request addGetParamsSign(Request request) throws UnsupportedEncodingException {
        HttpUrl httpUrl = request.url();
        HttpUrl.Builder newBuilder = httpUrl.newBuilder();
        Set nameSet = httpUrl.queryParameterNames();
        ArrayList nameList = new ArrayList();
        nameList.addAll(nameSet);
        TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
        for (int i = 0; i < nameList.size(); ++i) {
            String value = httpUrl.queryParameterValues((String)nameList.get(i)) != null && httpUrl.queryParameterValues((String)nameList.get(i)).size() > 0 ? (String)httpUrl.queryParameterValues((String)nameList.get(i)).get(0) : "";
            oldParams.put((String)nameList.get(i), value);
        }
        String nameKeys = Arrays.asList(nameList).toString();
        TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
        Utils.checkNotNull(newParams, "newParams==null");
        for (Map.Entry<String, Object> entry : newParams.entrySet()) {
            String urlValue = URLEncoder.encode(String.valueOf(entry.getValue()), HttpUtils.UTF8.name());
            if (nameKeys.contains(entry.getKey())) continue;
            newBuilder.addQueryParameter(entry.getKey(), urlValue);
        }
        httpUrl = newBuilder.build();
        request = request.newBuilder().url(httpUrl).build();
        return request;
    }

    private Request addPostParamsSign(Request request) throws UnsupportedEncodingException {
        if (request.body() instanceof FormBody) {
            FormBody.Builder bodyBuilder = new FormBody.Builder();
            FormBody formBody = (FormBody)request.body();
            TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
            for (int i = 0; i < formBody.size(); ++i) {
                oldParams.put(formBody.encodedName(i), formBody.encodedValue(i));
            }
            TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
            Utils.checkNotNull(newParams, "newParams == null");
            for (Map.Entry<String, Object> entry : newParams.entrySet()) {
                String value = URLDecoder.decode(String.valueOf(entry.getValue()), HttpUtils.UTF8.name());
                bodyBuilder.addEncoded(entry.getKey(), value);
            }
            String url = HttpUtils.createUrlFromParams(HttpUtils.parseUrl(this.mHttpUrl.url().toString()), newParams);
            HttpLog.i(url);
            formBody = bodyBuilder.build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        } else if (request.body() instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)request.body();
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            List oldParts = multipartBody.parts();
            ArrayList<MultipartBody.Part> newParts = new ArrayList<MultipartBody.Part>();
            newParts.addAll(oldParts);
            TreeMap<String, Object> oldParams = new TreeMap<String, Object>();
            TreeMap<String, Object> newParams = this.updateDynamicParams(oldParams);
            for (Map.Entry<String, Object> paramEntry : newParams.entrySet()) {
                MultipartBody.Part part = MultipartBody.Part.createFormData((String)paramEntry.getKey(), (String)String.valueOf(paramEntry.getValue()));
                newParts.add(part);
            }
            for (MultipartBody.Part part : newParts) {
                bodyBuilder.addPart(part);
            }
            multipartBody = bodyBuilder.build();
            request = request.newBuilder().post((RequestBody)multipartBody).build();
        } else if (request.body() instanceof RequestBody) {
            TreeMap<String, Object> params = this.updateDynamicParams(new TreeMap<String, Object>());
            String url = HttpUtils.createUrlFromParams(HttpUtils.parseUrl(this.mHttpUrl.url().toString()), params);
            request = request.newBuilder().url(url).build();
        }
        return request;
    }

    protected abstract TreeMap<String, Object> updateDynamicParams(TreeMap<String, Object> var1);
}

