/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.exception;

import android.net.ParseException;
import android.text.TextUtils;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.xuexiang.xhttp2.exception.ServerException;
import com.xuexiang.xhttp2.model.ApiResult;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import retrofit2.HttpException;

public class ApiException
extends Exception {
    private int mCode;

    public ApiException(String message, int code) {
        super(message);
        this.mCode = code;
    }

    public ApiException(Throwable e, int code) {
        super(e);
        this.mCode = code;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getDisplayMessage() {
        return this.getMessage();
    }

    public String getDetailMessage() {
        return "Code:" + this.mCode + ", Message:" + this.getMessage();
    }

    public static boolean isSuccess(ApiResult apiResult) {
        return apiResult != null && apiResult.isSuccess();
    }

    public static ApiException handleException(Throwable e) {
        if (e instanceof HttpException) {
            HttpException httpException = (HttpException)e;
            ApiException ex = !TextUtils.isEmpty((CharSequence)httpException.message()) ? new ApiException(httpException.message(), httpException.code()) : new ApiException(httpException.getMessage(), httpException.code());
            return ex;
        }
        if (e instanceof ServerException) {
            ServerException resultException = (ServerException)e;
            ApiException ex = new ApiException(resultException.getMessage(), resultException.getErrCode());
            return ex;
        }
        if (e instanceof JsonParseException || e instanceof JSONException || e instanceof JsonSyntaxException || e instanceof JsonSerializer || e instanceof NotSerializableException || e instanceof ParseException) {
            ApiException ex = new ApiException("\u89e3\u6790\u9519\u8bef", 5001);
            return ex;
        }
        if (e instanceof ClassCastException) {
            ApiException ex = new ApiException("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", 5007);
            return ex;
        }
        if (e instanceof ConnectException) {
            ApiException ex = new ApiException("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", 5002);
            return ex;
        }
        if (e instanceof SSLHandshakeException) {
            ApiException ex = new ApiException("\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25", 5004);
            return ex;
        }
        if (e instanceof ConnectTimeoutException) {
            ApiException ex = new ApiException("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", 5005);
            return ex;
        }
        if (e instanceof SocketTimeoutException) {
            ApiException ex = new ApiException("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", 5005);
            return ex;
        }
        if (e instanceof UnknownHostException) {
            ApiException ex = new ApiException("\u7f51\u7edc\u4e0d\u7ed9\u529b\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e", 5009);
            return ex;
        }
        if (e instanceof NullPointerException) {
            ApiException ex = new ApiException("\u7a7a\u6307\u9488\u9519\u8bef", 5010);
            return ex;
        }
        if (e instanceof OutOfMemoryError) {
            ApiException ex = new ApiException("\u5185\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6e05\u7406\u540e\u53f0\u5e94\u7528", 5011);
            return ex;
        }
        if (e instanceof InterruptedIOException) {
            ApiException ex = new ApiException("\u8bf7\u6c42\u88ab\u53d6\u6d88", 5008);
            return ex;
        }
        ApiException ex = new ApiException(e, 5000);
        return ex;
    }

    public static class ERROR {
        public static final int UNKNOWN = 5000;
        public static final int PARSE_ERROR = 5001;
        public static final int NET_WORD_ERROR = 5002;
        public static final int HTTP_ERROR = 5003;
        public static final int SSL_ERROR = 5004;
        public static final int TIMEOUT_ERROR = 5005;
        public static final int INVOKE_ERROR = 5006;
        public static final int CAST_ERROR = 5007;
        public static final int REQUEST_CANCEL = 5008;
        public static final int UN_KNOWN_HOST_ERROR = 5009;
        public static final int NULL_POINTER_ERROR = 5010;
        public static final int OUT_OF_MEMORY_ERROR = 5011;
        public static final int DOWNLOAD_ERROR = 5012;
        public static final int NET_METHOD_ANNOTATION_ERROR = 5012;
    }
}

