/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cookie;

import android.content.Context;
import com.xuexiang.xhttp2.cookie.PersistentCookieStore;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class CookieManager
implements CookieJar {
    private final PersistentCookieStore mCookieStore;
    private static CookieManager sInstance;

    private CookieManager(Context context) {
        this.mCookieStore = new PersistentCookieStore(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CookieManager getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<CookieManager> clazz = CookieManager.class;
        synchronized (CookieManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new CookieManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public void saveFromResponse(HttpUrl url, Cookie cookie) {
        if (cookie != null) {
            this.mCookieStore.add(url, cookie);
        }
    }

    public PersistentCookieStore getCookieStore() {
        return this.mCookieStore;
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (Cookie item : cookies) {
                this.mCookieStore.add(url, item);
            }
        }
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList cookies = this.mCookieStore.get(url);
        return cookies != null ? cookies : new ArrayList();
    }

    public void addCookies(List<Cookie> cookies) {
        this.mCookieStore.addCookies(cookies);
    }

    public void remove(HttpUrl url, Cookie cookie) {
        this.mCookieStore.remove(url, cookie);
    }

    public void removeAll() {
        this.mCookieStore.removeAll();
    }
}

