/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.callback;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xuexiang.xhttp2.callback.impl.IProgressResponseCallBack;
import java.io.Serializable;
import java.lang.ref.WeakReference;

public abstract class UIProgressResponseCallBack
implements IProgressResponseCallBack {
    private static final int RESPONSE_UPDATE = 2;
    private final Handler mHandler = new UIHandler(Looper.getMainLooper(), this);

    @Override
    public void onResponseProgress(long bytesWritten, long contentLength, boolean done) {
        Message message = Message.obtain();
        message.obj = new ProgressModel(bytesWritten, contentLength, done);
        message.what = 2;
        this.mHandler.sendMessage(message);
    }

    public abstract void onUIResponseProgress(long var1, long var3, boolean var5);

    public class ProgressModel
    implements Serializable {
        private long currentBytes;
        private long contentLength;
        private boolean done;

        public ProgressModel(long currentBytes, long contentLength, boolean done) {
            this.currentBytes = currentBytes;
            this.contentLength = contentLength;
            this.done = done;
        }

        public long getCurrentBytes() {
            return this.currentBytes;
        }

        public ProgressModel setCurrentBytes(long currentBytes) {
            this.currentBytes = currentBytes;
            return this;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public ProgressModel setContentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public boolean isDone() {
            return this.done;
        }

        public ProgressModel setDone(boolean done) {
            this.done = done;
            return this;
        }

        public String toString() {
            return "ProgressModel{currentBytes=" + this.currentBytes + ", contentLength=" + this.contentLength + ", done=" + this.done + '}';
        }
    }

    private static class UIHandler
    extends Handler {
        private final WeakReference<UIProgressResponseCallBack> mUIProgressResponseListenerWeakReference;

        public UIHandler(Looper looper, UIProgressResponseCallBack uiProgressResponseListener) {
            super(looper);
            this.mUIProgressResponseListenerWeakReference = new WeakReference<UIProgressResponseCallBack>(uiProgressResponseListener);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    UIProgressResponseCallBack uiProgressResponseListener = (UIProgressResponseCallBack)this.mUIProgressResponseListenerWeakReference.get();
                    if (uiProgressResponseListener == null) break;
                    ProgressModel progressModel = (ProgressModel)msg.obj;
                    uiProgressResponseListener.onUIResponseProgress(progressModel.getCurrentBytes(), progressModel.getContentLength(), progressModel.isDone());
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

