/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cache.core;

import com.jakewharton.disklrucache.DiskLruCache;
import com.xuexiang.xhttp2.cache.converter.IDiskConverter;
import com.xuexiang.xhttp2.cache.core.BaseDiskCache;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;

public class LruDiskCache
extends BaseDiskCache {
    public static final long CACHE_NEVER_EXPIRE = -1L;
    private IDiskConverter mDiskConverter;
    private DiskLruCache mDiskLruCache;
    private File mDiskDir;
    private int mAppVersion;
    private long mDiskMaxSize;

    public LruDiskCache(IDiskConverter diskConverter, File diskDir, int appVersion, long diskMaxSize) {
        this.mDiskConverter = Utils.checkNotNull(diskConverter, "mDiskConverter ==null");
        this.mDiskDir = Utils.checkNotNull(diskDir, "mDiskDir ==null");
        this.mAppVersion = appVersion;
        this.mDiskMaxSize = diskMaxSize;
        this.openCache();
    }

    private void openCache() {
        try {
            this.mDiskLruCache = DiskLruCache.open((File)this.mDiskDir, (int)this.mAppVersion, (int)1, (long)this.mDiskMaxSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            HttpLog.e(e);
        }
    }

    @Override
    protected <T> T doLoad(Type type, String key) {
        if (this.mDiskLruCache == null) {
            return null;
        }
        try {
            DiskLruCache.Editor edit = this.mDiskLruCache.edit(key);
            if (edit == null) {
                return null;
            }
            InputStream source = edit.newInputStream(0);
            if (source != null) {
                Object value = this.mDiskConverter.load(source, type);
                Utils.closeIO(source);
                edit.commit();
                return value;
            }
            edit.abort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected <T> boolean doSave(String key, T value) {
        if (this.mDiskLruCache == null) {
            return false;
        }
        try {
            DiskLruCache.Editor edit = this.mDiskLruCache.edit(key);
            if (edit == null) {
                return false;
            }
            OutputStream sink = edit.newOutputStream(0);
            if (sink != null) {
                this.mDiskConverter.writer(sink, value);
                Utils.closeIO(sink);
                edit.commit();
                return true;
            }
            edit.abort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected boolean doContainsKey(String key) {
        if (this.mDiskLruCache == null) {
            return false;
        }
        try {
            return this.mDiskLruCache.get(key) != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean doRemove(String key) {
        if (this.mDiskLruCache == null) {
            return false;
        }
        try {
            return this.mDiskLruCache.remove(key);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean doClear() {
        boolean status = false;
        try {
            this.mDiskLruCache.delete();
            this.openCache();
            status = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    protected boolean isExpiry(String key, long existTime) {
        if (this.mDiskLruCache == null) {
            return false;
        }
        if (existTime > -1L) {
            File file = new File(this.mDiskLruCache.getDirectory(), key + "." + 0);
            return this.isCacheDataFailure(file, existTime);
        }
        return false;
    }

    private boolean isCacheDataFailure(File dataFile, long time) {
        if (!dataFile.exists()) {
            return false;
        }
        long existTime = System.currentTimeMillis() - dataFile.lastModified();
        return existTime > time * 1000L;
    }
}

