/*
 * Decompiled with CFR 0.152.
 */
package com.hbzhou.open.flowcamera.util;

import android.hardware.Camera;
import android.media.AudioRecord;
import android.util.Log;

public class CheckPermission {
    public static final int STATE_RECORDING = -1;
    public static final int STATE_NO_PERMISSION = -2;
    public static final int STATE_SUCCESS = 1;

    public static int getRecordState() {
        int minBuffer = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
        AudioRecord audioRecord = new AudioRecord(0, 44100, 16, 2, minBuffer * 100);
        short[] point = new short[minBuffer];
        int readSize = 0;
        try {
            audioRecord.startRecording();
        }
        catch (Exception e) {
            if (audioRecord != null) {
                audioRecord.release();
                audioRecord = null;
            }
            return -2;
        }
        if (audioRecord.getRecordingState() != 3) {
            if (audioRecord != null) {
                audioRecord.stop();
                audioRecord.release();
                audioRecord = null;
                Log.d((String)"CheckAudioPermission", (String)"\u5f55\u97f3\u673a\u88ab\u5360\u7528");
            }
            return -1;
        }
        readSize = audioRecord.read(point, 0, point.length);
        if (readSize <= 0) {
            if (audioRecord != null) {
                audioRecord.stop();
                audioRecord.release();
                audioRecord = null;
            }
            Log.d((String)"CheckAudioPermission", (String)"\u5f55\u97f3\u7684\u7ed3\u679c\u4e3a\u7a7a");
            return -2;
        }
        if (audioRecord != null) {
            audioRecord.stop();
            audioRecord.release();
            audioRecord = null;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isCameraUseable(int cameraID) {
        boolean canUse = true;
        Camera mCamera = null;
        try {
            mCamera = Camera.open((int)cameraID);
            Camera.Parameters mParameters = mCamera.getParameters();
            mCamera.setParameters(mParameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            canUse = false;
        }
        finally {
            if (mCamera != null) {
                mCamera.release();
            } else {
                canUse = false;
            }
            mCamera = null;
        }
        return canUse;
    }
}

