/*
 * Decompiled with CFR 0.152.
 */
package com.hbzhou.open.flowcamera;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.media.MediaScannerConnection;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.bumptech.glide.Glide;
import com.hbzhou.open.flowcamera.CaptureLayout;
import com.hbzhou.open.flowcamera.CaptureListener;
import com.hbzhou.open.flowcamera.R;
import com.hbzhou.open.flowcamera.listener.ClickListener;
import com.hbzhou.open.flowcamera.listener.FlowCameraListener;
import com.hbzhou.open.flowcamera.listener.OnVideoPlayPrepareListener;
import com.hbzhou.open.flowcamera.listener.TypeListener;
import com.hbzhou.open.flowcamera.util.LogUtil;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraListener;
import com.otaliastudios.cameraview.CameraView;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.Preview;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.SizeSelector;
import com.otaliastudios.cameraview.size.SizeSelectors;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class CustomCameraView
extends FrameLayout {
    private Context mContext;
    private CameraView mCameraView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private FlowCameraListener flowCameraListener;
    private ClickListener leftClickListener;
    private File videoFile;
    private File photoFile;
    private int iconSrc;
    private int iconLeft;
    private int iconRight;
    private int duration;
    private long recordTime = 0L;

    public CustomCameraView(@NonNull Context context) {
        this(context, null);
    }

    public CustomCameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomCameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CustomCameraView, defStyleAttr, 0);
        this.iconSrc = a.getResourceId(R.styleable.CustomCameraView_iconSrc, R.drawable.ic_camera);
        this.iconLeft = a.getResourceId(R.styleable.CustomCameraView_iconLeft, 0);
        this.iconRight = a.getResourceId(R.styleable.CustomCameraView_iconRight, 0);
        this.duration = a.getInteger(R.styleable.CustomCameraView_duration_max, 10000);
        a.recycle();
        this.initView();
    }

    public void initView() {
        this.setWillNotDraw(false);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.custom_camera_view, (ViewGroup)this);
        this.mCameraView = (CameraView)view.findViewById(R.id.video_preview);
        this.mTextureView = (TextureView)view.findViewById(R.id.mVideo);
        this.mPhoto = (ImageView)view.findViewById(R.id.image_photo);
        this.mSwitchCamera = (ImageView)view.findViewById(R.id.image_switch);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.mCaptureLayout = (CaptureLayout)view.findViewById(R.id.capture_layout);
        this.mCaptureLayout.setDuration(this.duration);
        this.mCaptureLayout.setIconSrc(this.iconLeft, this.iconRight);
        this.mSwitchCamera.setOnClickListener(v -> this.mCameraView.toggleFacing());
        this.mCameraView.setPreview(Preview.GL_SURFACE);
        this.mCameraView.setAutoFocusResetDelay(0L);
        this.mCameraView.setSnapshotMaxHeight(2160);
        this.mCameraView.setSnapshotMaxWidth(1080);
        SizeSelector width = SizeSelectors.maxWidth((int)1080);
        SizeSelector height = SizeSelectors.maxHeight((int)2160);
        SizeSelector dimensions = SizeSelectors.and((SizeSelector[])new SizeSelector[]{width, height});
        SizeSelector ratio = SizeSelectors.aspectRatio((AspectRatio)AspectRatio.of((int)9, (int)16), (float)0.0f);
        SizeSelector result = SizeSelectors.or((SizeSelector[])new SizeSelector[]{SizeSelectors.and((SizeSelector[])new SizeSelector[]{ratio, dimensions}), ratio, SizeSelectors.biggest()});
        this.mCameraView.setPreviewStreamSize(result);
        this.mCameraView.setVideoSize(result);
        this.mCameraView.setPictureSize(result);
        this.mCameraView.addCameraListener(new CameraListener(){

            public void onCameraError(@NonNull CameraException exception) {
                super.onCameraError(exception);
                if (CustomCameraView.this.flowCameraListener != null) {
                    CustomCameraView.this.flowCameraListener.onError(0, Objects.requireNonNull(exception.getMessage()), null);
                }
            }

            public void onPictureTaken(@NonNull PictureResult result) {
                super.onPictureTaken(result);
                result.toFile(CustomCameraView.this.initTakePicPath(CustomCameraView.this.mContext), file -> {
                    if (file == null || !file.exists()) {
                        Toast.makeText((Context)CustomCameraView.this.mContext, (CharSequence)"\u6587\u4ef6\u4e0d\u5b58\u5728!", (int)1).show();
                        return;
                    }
                    CustomCameraView.this.photoFile = file;
                    Glide.with((Context)CustomCameraView.this.mContext).load(file).into(CustomCameraView.this.mPhoto);
                    CustomCameraView.this.mPhoto.setVisibility(0);
                    CustomCameraView.this.mCaptureLayout.startTypeBtnAnimator();
                });
            }

            public void onVideoTaken(@NonNull VideoResult result) {
                super.onVideoTaken(result);
                CustomCameraView.this.videoFile = result.getFile();
                if (!CustomCameraView.this.videoFile.exists() || CustomCameraView.this.recordTime < 1500L && CustomCameraView.this.videoFile.exists() && CustomCameraView.this.videoFile.delete()) {
                    return;
                }
                CustomCameraView.this.mCaptureLayout.startTypeBtnAnimator();
                CustomCameraView.this.mTextureView.setVisibility(0);
                if (CustomCameraView.this.mTextureView.isAvailable()) {
                    CustomCameraView.this.startVideoPlay(CustomCameraView.this.videoFile, () -> CustomCameraView.this.mCameraView.setVisibility(8));
                } else {
                    CustomCameraView.this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                            CustomCameraView.this.startVideoPlay(CustomCameraView.this.videoFile, () -> CustomCameraView.this.mCameraView.setVisibility(8));
                        }

                        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                        }

                        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                            return false;
                        }

                        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                        }
                    });
                }
            }
        });
        this.mCaptureLayout.setCaptureLisenter(new CaptureListener(){

            @Override
            public void takePictures() {
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mCameraView.setMode(Mode.PICTURE);
                CustomCameraView.this.mCameraView.takePictureSnapshot();
            }

            @Override
            public void recordStart() {
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mCameraView.setMode(Mode.VIDEO);
                CustomCameraView.this.mCameraView.postDelayed(() -> CustomCameraView.this.mCameraView.takeVideoSnapshot(CustomCameraView.this.initStartRecordingPath(CustomCameraView.this.mContext)), 100L);
            }

            @Override
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation("\u5f55\u5236\u65f6\u95f4\u8fc7\u77ed");
                CustomCameraView.this.mCameraView.stopVideo();
            }

            @Override
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mCameraView.stopVideo();
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.flowCameraListener != null) {
                    CustomCameraView.this.flowCameraListener.onError(0, "\u672a\u77e5\u539f\u56e0!", null);
                }
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.stopVideoPlay();
                CustomCameraView.this.resetState();
            }

            @Override
            public void confirm() {
                if (CustomCameraView.this.mCameraView.getMode() == Mode.VIDEO) {
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.flowCameraListener != null) {
                        CustomCameraView.this.flowCameraListener.recordSuccess(CustomCameraView.this.videoFile);
                    }
                    CustomCameraView.this.scanPhotoAlbum(CustomCameraView.this.videoFile);
                } else {
                    CustomCameraView.this.mPhoto.setVisibility(4);
                    if (CustomCameraView.this.flowCameraListener != null) {
                        CustomCameraView.this.flowCameraListener.captureSuccess(CustomCameraView.this.photoFile);
                    }
                    CustomCameraView.this.scanPhotoAlbum(CustomCameraView.this.photoFile);
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(() -> {
            if (this.leftClickListener != null) {
                this.leftClickListener.onClick();
            }
        });
    }

    private void scanPhotoAlbum(File dataFile) {
        if (dataFile == null) {
            return;
        }
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(dataFile.getAbsolutePath().substring(dataFile.getAbsolutePath().lastIndexOf(".") + 1));
        MediaScannerConnection.scanFile((Context)this.mContext, (String[])new String[]{dataFile.getAbsolutePath()}, (String[])new String[]{mimeType}, null);
    }

    public File initTakePicPath(Context context) {
        return new File(context.getExternalMediaDirs()[0], System.currentTimeMillis() + ".jpeg");
    }

    public File initStartRecordingPath(Context context) {
        return new File(context.getExternalMediaDirs()[0], System.currentTimeMillis() + ".mp4");
    }

    public void setFlowCameraListener(FlowCameraListener flowCameraListener) {
        this.flowCameraListener = flowCameraListener;
    }

    public void setBindToLifecycle(LifecycleOwner lifecycleOwner) {
        this.mCameraView.setLifecycleOwner(lifecycleOwner);
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)((LifecycleEventObserver)(source, event) -> {
            LogUtil.i("event---", event.toString());
            if (event == Lifecycle.Event.ON_RESUME) {
                this.mCameraView.open();
            } else if (event == Lifecycle.Event.ON_PAUSE) {
                this.mCameraView.close();
            } else if (event == Lifecycle.Event.ON_DESTROY) {
                this.mCameraView.destroy();
            }
        }));
    }

    public void setCaptureMode(int state) {
        if (this.mCaptureLayout != null) {
            this.mCaptureLayout.setButtonFeatures(state);
        }
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime * 1000);
    }

    public void setHdrEnable(Hdr hdr) {
        this.mCameraView.setHdr(hdr);
    }

    public void setWhiteBalance(WhiteBalance whiteBalance) {
        this.mCameraView.setWhiteBalance(whiteBalance);
    }

    public void setLeftClickListener(ClickListener clickListener) {
        this.leftClickListener = clickListener;
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_auto);
                this.mCameraView.setFlash(Flash.AUTO);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_on);
                this.mCameraView.setFlash(Flash.ON);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_off);
                this.mCameraView.setFlash(Flash.OFF);
            }
        }
    }

    private void resetState() {
        if (this.mCameraView.getMode() == Mode.VIDEO) {
            if (this.mCameraView.isTakingVideo()) {
                this.mCameraView.stopVideo();
            }
            if (this.videoFile != null && this.videoFile.exists() && this.videoFile.delete()) {
                LogUtil.i("videoFile is clear");
            }
        } else {
            this.mPhoto.setVisibility(4);
            if (this.photoFile != null && this.photoFile.exists() && this.photoFile.delete()) {
                LogUtil.i("photoFile is clear");
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mCameraView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(File videoFile, OnVideoPlayPrepareListener onVideoPlayPrepareListener) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            }
            this.mMediaPlayer.setDataSource(videoFile.getAbsolutePath());
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.setOnPreparedListener(mp -> {
                mp.start();
                float ratio = (float)mp.getVideoWidth() * 1.0f / (float)mp.getVideoHeight();
                int width1 = this.mTextureView.getWidth();
                ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
                layoutParams.height = (int)((float)width1 / ratio);
                this.mTextureView.setLayoutParams(layoutParams);
                if (onVideoPlayPrepareListener != null) {
                    onVideoPlayPrepareListener.onPrepared();
                }
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }
}

