/*
 * Decompiled with CFR 0.152.
 */
package com.hbzhou.open.flowcamera;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.hbzhou.open.flowcamera.CaptureListener;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 P2\u00020\u0001:\u0003PQRB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00103\u001a\u000204H\u0002J\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u0002042\u0006\u00108\u001a\u000209H\u0014J\u0018\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0014J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u000204H\u0002J\b\u0010A\u001a\u000204H\u0002J\u0006\u0010B\u001a\u000204J\u000e\u0010C\u001a\u0002042\u0006\u0010/\u001a\u00020\tJ\u0010\u0010D\u001a\u0002042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010E\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010F\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\tJ\u0010\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020\u0016H\u0002J(\u0010I\u001a\u0002042\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u0016H\u0002J\u0010\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020OH\u0002R\u0014\u0010\u000b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0018\u00010$R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0018\u000102R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/hbzhou/open/flowcamera/CaptureImageButton;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "size", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "STATE_BAN", "getSTATE_BAN", "()I", "STATE_IDLE", "getSTATE_IDLE", "STATE_LONG_PRESS", "STATE_PRESS", "getSTATE_PRESS", "STATE_RECORDERING", "getSTATE_RECORDERING", "button_inside_radius", "", "button_outside_radius", "button_radius", "button_size", "button_state", "captureListener", "Lcom/hbzhou/open/flowcamera/CaptureListener;", "center_X", "center_Y", "duration", "event_Y", "inside_color", "inside_reduce_size", "longPressRunnable", "Lcom/hbzhou/open/flowcamera/CaptureImageButton$LongPressRunnable;", "mPaint", "Landroid/graphics/Paint;", "min_duration", "outside_add_size", "outside_color", "progress", "progress_color", "recorded_time", "rectF", "Landroid/graphics/RectF;", "state", "strokeWidth", "timer", "Lcom/hbzhou/open/flowcamera/CaptureImageButton$RecordCountDownTimer;", "handlerUnpressByState", "", "isIdle", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "recordEnd", "resetRecordAnim", "resetState", "setButtonFeatures", "setCaptureLisenter", "setDuration", "setMinDuration", "startCaptureAnimation", "inside_start", "startRecordAnimation", "outside_start", "outside_end", "inside_end", "updateProgress", "millisUntilFinished", "", "Companion", "LongPressRunnable", "RecordCountDownTimer", "flowcamera_release"})
public final class CaptureImageButton
extends View {
    private int state;
    private int button_state;
    private final int STATE_IDLE = 1;
    private final int STATE_PRESS = 2;
    private final int STATE_LONG_PRESS = 3;
    private final int STATE_RECORDERING = 4;
    private final int STATE_BAN = 5;
    private final int progress_color = -300503530;
    private final int outside_color = -287515428;
    private final int inside_color = -1;
    private float event_Y;
    private Paint mPaint;
    private float strokeWidth;
    private int outside_add_size;
    private int inside_reduce_size;
    private float center_X;
    private float center_Y;
    private float button_radius;
    private float button_outside_radius;
    private float button_inside_radius;
    private int button_size;
    private float progress;
    private int duration;
    private int min_duration;
    private int recorded_time;
    private RectF rectF;
    private LongPressRunnable longPressRunnable;
    private CaptureListener captureListener;
    private RecordCountDownTimer timer;
    private static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    private static final int BUTTON_STATE_ONLY_RECORDER = 258;
    private static final int BUTTON_STATE_BOTH = 259;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getSTATE_IDLE() {
        return this.STATE_IDLE;
    }

    public final int getSTATE_PRESS() {
        return this.STATE_PRESS;
    }

    public final int getSTATE_RECORDERING() {
        return this.STATE_RECORDERING;
    }

    public final int getSTATE_BAN() {
        return this.STATE_BAN;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.button_size + this.outside_add_size * 2, this.button_size + this.outside_add_size * 2);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStyle(Paint.Style.FILL);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setColor(this.outside_color);
        }
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(this.center_X, this.center_Y, this.button_outside_radius, paint3);
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setColor(this.inside_color);
        }
        Paint paint5 = this.mPaint;
        if (paint5 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawCircle(this.center_X, this.center_Y, this.button_inside_radius, paint5);
        if (this.state == this.STATE_RECORDERING) {
            Paint paint6 = this.mPaint;
            if (paint6 != null) {
                paint6.setColor(this.progress_color);
            }
            Paint paint7 = this.mPaint;
            if (paint7 != null) {
                paint7.setStyle(Paint.Style.STROKE);
            }
            Paint paint8 = this.mPaint;
            if (paint8 != null) {
                paint8.setStrokeWidth(this.strokeWidth);
            }
            RectF rectF = this.rectF;
            if (rectF == null) {
                Intrinsics.throwNpe();
            }
            Paint paint9 = this.mPaint;
            if (paint9 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawArc(rectF, -90.0f, this.progress, false, paint9);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                if (event.getPointerCount() > 1 || this.state != this.STATE_IDLE) {
                    return false;
                }
                this.event_Y = event.getY();
                this.state = this.STATE_PRESS;
                if (this.button_state != BUTTON_STATE_ONLY_RECORDER && this.button_state != BUTTON_STATE_BOTH) break;
                this.postDelayed(this.longPressRunnable, 500L);
                break;
            }
            case 2: {
                if (this.captureListener == null || this.state != this.STATE_RECORDERING || this.button_state != BUTTON_STATE_ONLY_RECORDER && this.button_state != BUTTON_STATE_BOTH) break;
                CaptureListener captureListener = this.captureListener;
                if (captureListener == null) {
                    Intrinsics.throwNpe();
                }
                captureListener.recordZoom(this.event_Y - event.getY());
                break;
            }
            case 1: {
                this.handlerUnpressByState();
                break;
            }
        }
        return true;
    }

    private final void handlerUnpressByState() {
        block4: {
            int n;
            block3: {
                this.removeCallbacks(this.longPressRunnable);
                n = this.state;
                if (n != this.STATE_PRESS) break block3;
                if (this.captureListener != null && (this.button_state == BUTTON_STATE_ONLY_CAPTURE || this.button_state == BUTTON_STATE_BOTH)) {
                    this.startCaptureAnimation(this.button_inside_radius);
                } else {
                    this.state = this.STATE_IDLE;
                }
                break block4;
            }
            if (n != this.STATE_RECORDERING) break block4;
            RecordCountDownTimer recordCountDownTimer = this.timer;
            if (recordCountDownTimer == null) {
                Intrinsics.throwNpe();
            }
            recordCountDownTimer.cancel();
            this.recordEnd();
        }
    }

    private final void recordEnd() {
        if (this.captureListener != null) {
            if (this.recorded_time < this.min_duration) {
                CaptureListener captureListener = this.captureListener;
                if (captureListener != null) {
                    captureListener.recordShort(this.recorded_time);
                }
            } else {
                CaptureListener captureListener = this.captureListener;
                if (captureListener != null) {
                    captureListener.recordEnd(this.recorded_time);
                }
            }
        }
        this.resetRecordAnim();
    }

    private final void resetRecordAnim() {
        this.state = this.STATE_BAN;
        this.progress = 0.0f;
        this.invalidate();
        this.startRecordAnimation(this.button_outside_radius, this.button_radius, this.button_inside_radius, this.button_radius * 0.75f);
    }

    private final void startCaptureAnimation(float inside_start) {
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_start * 0.75f, inside_start});
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CaptureImageButton this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                CaptureImageButton.access$setButton_inside_radius$p(this.this$0, ((Float)object).floatValue());
                this.this$0.invalidate();
            }
            {
                this.this$0 = captureImageButton;
            }
        });
        inside_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ CaptureImageButton this$0;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                CaptureListener captureListener = CaptureImageButton.access$getCaptureListener$p(this.this$0);
                if (captureListener != null) {
                    captureListener.takePictures();
                }
                CaptureImageButton.access$setState$p(this.this$0, this.this$0.getSTATE_BAN());
            }
            {
                this.this$0 = $outer;
            }
        });
        ValueAnimator valueAnimator = inside_anim;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"inside_anim");
        valueAnimator.setDuration(100L);
        inside_anim.start();
    }

    private final void startRecordAnimation(float outside_start, float outside_end, float inside_start, float inside_end) {
        ValueAnimator outside_anim = ValueAnimator.ofFloat((float[])new float[]{outside_start, outside_end});
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_end});
        outside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CaptureImageButton this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                CaptureImageButton.access$setButton_outside_radius$p(this.this$0, ((Float)object).floatValue());
                this.this$0.invalidate();
            }
            {
                this.this$0 = captureImageButton;
            }
        });
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CaptureImageButton this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                CaptureImageButton.access$setButton_inside_radius$p(this.this$0, ((Float)object).floatValue());
                this.this$0.invalidate();
            }
            {
                this.this$0 = captureImageButton;
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ CaptureImageButton this$0;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                if (CaptureImageButton.access$getState$p(this.this$0) == CaptureImageButton.access$getSTATE_LONG_PRESS$p(this.this$0)) {
                    if (CaptureImageButton.access$getCaptureListener$p(this.this$0) != null) {
                        CaptureListener captureListener = CaptureImageButton.access$getCaptureListener$p(this.this$0);
                        if (captureListener != null) {
                            captureListener.recordStart();
                        }
                    }
                    CaptureImageButton.access$setState$p(this.this$0, this.this$0.getSTATE_RECORDERING());
                    RecordCountDownTimer recordCountDownTimer = CaptureImageButton.access$getTimer$p(this.this$0);
                    if (recordCountDownTimer == null) {
                        Intrinsics.throwNpe();
                    }
                    recordCountDownTimer.start();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        set.playTogether(new Animator[]{(Animator)outside_anim, (Animator)inside_anim});
        set.setDuration(100L);
        set.start();
    }

    private final void updateProgress(long millisUntilFinished) {
        this.recorded_time = (int)((long)this.duration - millisUntilFinished);
        this.progress = 360.0f - (float)millisUntilFinished / (float)this.duration * 360.0f;
        this.invalidate();
    }

    public final void setDuration(int duration) {
        this.duration = duration;
        this.timer = new RecordCountDownTimer(duration, duration / 360);
    }

    public final void setMinDuration(int duration) {
        this.min_duration = duration;
    }

    public final void setCaptureLisenter(@Nullable CaptureListener captureListener) {
        this.captureListener = captureListener;
    }

    public final void setButtonFeatures(int state) {
        this.button_state = state;
    }

    public final boolean isIdle() {
        return this.state == this.STATE_IDLE;
    }

    public final void resetState() {
        this.state = this.STATE_IDLE;
    }

    public CaptureImageButton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public CaptureImageButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public CaptureImageButton(@NotNull Context context, @Nullable AttributeSet attrs, int size) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, size);
        this.STATE_IDLE = 1;
        this.STATE_PRESS = 2;
        this.STATE_LONG_PRESS = 3;
        this.STATE_RECORDERING = 4;
        this.STATE_BAN = 5;
        this.progress_color = -300503530;
        this.outside_color = -287515428;
        this.inside_color = -1;
        this.button_size = size;
        this.button_outside_radius = this.button_radius = (float)size / 2.0f;
        this.button_inside_radius = this.button_radius * 0.75f;
        this.strokeWidth = (float)size / (float)15;
        this.outside_add_size = size / 5;
        this.inside_reduce_size = size / 8;
        Paint paint = this.mPaint = new Paint();
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setAntiAlias(true);
        this.progress = 0.0f;
        this.longPressRunnable = new LongPressRunnable();
        this.state = this.STATE_IDLE;
        this.button_state = BUTTON_STATE_BOTH;
        this.duration = 10000;
        this.min_duration = 1500;
        this.center_X = (float)(this.button_size + this.outside_add_size * 2) / (float)2;
        this.center_Y = (float)(this.button_size + this.outside_add_size * 2) / (float)2;
        this.rectF = new RectF(this.center_X - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / (float)2), this.center_Y - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / (float)2), this.center_X + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / (float)2), this.center_Y + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / (float)2));
        this.timer = new RecordCountDownTimer(this.duration, this.duration / 360);
    }

    static {
        BUTTON_STATE_ONLY_CAPTURE = 257;
        BUTTON_STATE_ONLY_RECORDER = 258;
        BUTTON_STATE_BOTH = 259;
    }

    public static final /* synthetic */ int access$getState$p(CaptureImageButton $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setCaptureListener$p(CaptureImageButton $this, CaptureListener captureListener) {
        $this.captureListener = captureListener;
    }

    public static final /* synthetic */ void access$setButton_outside_radius$p(CaptureImageButton $this, float f) {
        $this.button_outside_radius = f;
    }

    public static final /* synthetic */ void access$setOutside_add_size$p(CaptureImageButton $this, int n) {
        $this.outside_add_size = n;
    }

    public static final /* synthetic */ void access$setButton_inside_radius$p(CaptureImageButton $this, float f) {
        $this.button_inside_radius = f;
    }

    public static final /* synthetic */ void access$setInside_reduce_size$p(CaptureImageButton $this, int n) {
        $this.inside_reduce_size = n;
    }

    public static final /* synthetic */ RecordCountDownTimer access$getTimer$p(CaptureImageButton $this) {
        return $this.timer;
    }

    public static final /* synthetic */ void access$setTimer$p(CaptureImageButton $this, RecordCountDownTimer recordCountDownTimer) {
        $this.timer = recordCountDownTimer;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/hbzhou/open/flowcamera/CaptureImageButton$RecordCountDownTimer;", "Landroid/os/CountDownTimer;", "millisInFuture", "", "countDownInterval", "(Lcom/hbzhou/open/flowcamera/CaptureImageButton;JJ)V", "onFinish", "", "onTick", "millisUntilFinished", "flowcamera_release"})
    public final class RecordCountDownTimer
    extends CountDownTimer {
        public void onTick(long millisUntilFinished) {
            CaptureImageButton.this.updateProgress(millisUntilFinished);
        }

        public void onFinish() {
            CaptureImageButton.this.updateProgress(0L);
            CaptureImageButton.this.recordEnd();
        }

        public RecordCountDownTimer(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/hbzhou/open/flowcamera/CaptureImageButton$LongPressRunnable;", "Ljava/lang/Runnable;", "(Lcom/hbzhou/open/flowcamera/CaptureImageButton;)V", "run", "", "flowcamera_release"})
    public final class LongPressRunnable
    implements Runnable {
        @Override
        public void run() {
            CaptureImageButton.this.state = CaptureImageButton.this.STATE_LONG_PRESS;
            CaptureImageButton.this.state = CaptureImageButton.this.getSTATE_IDLE();
            if (CaptureImageButton.this.captureListener != null) {
                CaptureListener captureListener = CaptureImageButton.this.captureListener;
                if (captureListener != null) {
                    captureListener.recordError();
                }
                return;
            }
            CaptureImageButton.this.startRecordAnimation(CaptureImageButton.this.button_outside_radius, CaptureImageButton.this.button_outside_radius + (float)CaptureImageButton.this.outside_add_size, CaptureImageButton.this.button_inside_radius, CaptureImageButton.this.button_inside_radius - (float)CaptureImageButton.this.inside_reduce_size);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/hbzhou/open/flowcamera/CaptureImageButton$Companion;", "", "()V", "BUTTON_STATE_BOTH", "", "getBUTTON_STATE_BOTH", "()I", "BUTTON_STATE_ONLY_CAPTURE", "getBUTTON_STATE_ONLY_CAPTURE", "BUTTON_STATE_ONLY_RECORDER", "getBUTTON_STATE_ONLY_RECORDER", "flowcamera_release"})
    public static final class Companion {
        public final int getBUTTON_STATE_ONLY_CAPTURE() {
            return BUTTON_STATE_ONLY_CAPTURE;
        }

        public final int getBUTTON_STATE_ONLY_RECORDER() {
            return BUTTON_STATE_ONLY_RECORDER;
        }

        public final int getBUTTON_STATE_BOTH() {
            return BUTTON_STATE_BOTH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

