/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.bilibili.boxing.AbsBoxingViewFragment;
import com.bilibili.boxing.model.BoxingManager;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.adapter.BoxingMediaAdapter;
import com.bilibili.boxing_impl.view.SpacesItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class BoxingBottomSheetFragment
extends AbsBoxingViewFragment
implements View.OnClickListener {
    public static final String TAG = "com.bilibili.boxing_impl.ui.BoxingBottomSheetFragment";
    private static final int GRID_COUNT = 3;
    private boolean mIsCamera;
    private BoxingMediaAdapter mMediaAdapter;
    private ProgressDialog mDialog;
    private RecyclerView mRecycleView;
    private TextView mEmptyTxt;
    private ProgressBar mLoadingView;

    public static BoxingBottomSheetFragment newInstance() {
        return new BoxingBottomSheetFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mMediaAdapter = new BoxingMediaAdapter((Context)this.getActivity());
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_boxing_bottom_sheet, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mEmptyTxt = (TextView)view.findViewById(R.id.empty_txt);
        this.mRecycleView = (RecyclerView)view.findViewById(R.id.media_recycleview);
        this.mLoadingView = (ProgressBar)view.findViewById(R.id.loading);
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 3);
        gridLayoutManager.setSmoothScrollbarEnabled(true);
        this.mRecycleView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mRecycleView.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration(this.getResources().getDimensionPixelOffset(R.dimen.boxing_media_margin), 3));
        this.mRecycleView.setAdapter((RecyclerView.Adapter)this.mMediaAdapter);
        this.mRecycleView.addOnScrollListener((RecyclerView.OnScrollListener)new ScrollListener());
        this.mMediaAdapter.setOnMediaClickListener(new OnMediaClickListener());
        this.mMediaAdapter.setOnCameraClickListener(new OnCameraClickListener());
        view.findViewById(R.id.finish_txt).setOnClickListener((View.OnClickListener)this);
    }

    public void onCameraActivityResult(int requestCode, int resultCode) {
        this.showProgressDialog();
        super.onCameraActivityResult(requestCode, resultCode);
    }

    private void showProgressDialog() {
        if (this.mDialog == null) {
            this.mDialog = new ProgressDialog((Context)this.getActivity());
            this.mDialog.setIndeterminate(true);
            this.mDialog.setMessage((CharSequence)this.getString(R.string.boxing_handling));
        }
        if (!this.mDialog.isShowing()) {
            this.mDialog.show();
        }
    }

    private void dismissProgressDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
            this.mDialog.dismiss();
        }
    }

    public void showMedia(List<BaseMedia> medias, int count) {
        if (medias == null || this.isEmptyData(medias) && this.isEmptyData(this.mMediaAdapter.getAllMedias())) {
            this.showEmptyData();
            return;
        }
        this.showData();
        this.mMediaAdapter.addAllData(medias);
    }

    private boolean isEmptyData(List<BaseMedia> medias) {
        return medias.isEmpty() && !BoxingManager.getInstance().getBoxingConfig().isNeedCamera();
    }

    private void showEmptyData() {
        this.mEmptyTxt.setVisibility(0);
        this.mRecycleView.setVisibility(8);
        this.mLoadingView.setVisibility(8);
    }

    private void showData() {
        this.mLoadingView.setVisibility(8);
        this.mEmptyTxt.setVisibility(8);
        this.mRecycleView.setVisibility(0);
    }

    public void onCameraFinish(BaseMedia media) {
        this.dismissProgressDialog();
        this.mIsCamera = false;
        if (media != null) {
            List<BaseMedia> selectedMedias = this.mMediaAdapter.getSelectedMedias();
            selectedMedias.add(media);
            this.onFinish(selectedMedias);
        }
    }

    public void onCameraError() {
        this.mIsCamera = false;
        this.dismissProgressDialog();
    }

    public void startLoading() {
        this.loadMedias();
    }

    public void onRequestPermissionError(String[] permissions, Exception e) {
        if (permissions.length > 0 && permissions[0].equals("android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.showEmptyData();
            Toast.makeText((Context)this.getContext(), (int)R.string.boxing_storage_permission_deny, (int)0).show();
        }
    }

    public void onRequestPermissionSuc(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions[0].equals(STORAGE_PERMISSIONS[0])) {
            this.startLoading();
        }
    }

    public void clearMedia() {
        this.mMediaAdapter.clearData();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.finish_txt == id2) {
            this.onFinish(null);
        }
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        private ScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int childCount = recyclerView.getChildCount();
            if (childCount > 0) {
                View lastChild = recyclerView.getChildAt(childCount - 1);
                RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
                int lastVisible = recyclerView.getChildAdapterPosition(lastChild);
                if (lastVisible == outerAdapter.getItemCount() - 1 && BoxingBottomSheetFragment.this.hasNextPage() && BoxingBottomSheetFragment.this.canLoadNextPage()) {
                    BoxingBottomSheetFragment.this.onLoadNextPage();
                }
            }
        }
    }

    private class OnCameraClickListener
    implements View.OnClickListener {
        private OnCameraClickListener() {
        }

        public void onClick(View v) {
            if (!BoxingBottomSheetFragment.this.mIsCamera) {
                BoxingBottomSheetFragment.this.mIsCamera = true;
                BoxingBottomSheetFragment.this.startCamera((Activity)BoxingBottomSheetFragment.this.getActivity(), (Fragment)BoxingBottomSheetFragment.this, "/bili/boxing");
            }
        }
    }

    private class OnMediaClickListener
    implements View.OnClickListener {
        private OnMediaClickListener() {
        }

        public void onClick(View v) {
            ArrayList<BaseMedia> iMedias = new ArrayList<BaseMedia>();
            BaseMedia media = (BaseMedia)v.getTag();
            iMedias.add(media);
            BoxingBottomSheetFragment.this.onFinish(iMedias);
        }
    }
}

