/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.TextView;
import com.bilibili.boxing.AbsBoxingActivity;
import com.bilibili.boxing.AbsBoxingViewFragment;
import com.bilibili.boxing.model.config.BoxingConfig;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.ui.BoxingViewFragment;
import java.util.ArrayList;
import java.util.List;

public class BoxingActivity
extends AbsBoxingActivity {
    private BoxingViewFragment mPickerFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_boxing);
        this.createToolbar();
        this.setTitleTxt(this.getBoxingConfig());
    }

    @NonNull
    public AbsBoxingViewFragment onCreateBoxingView(ArrayList<BaseMedia> medias) {
        this.mPickerFragment = (BoxingViewFragment)this.getSupportFragmentManager().findFragmentByTag("com.bilibili.boxing_impl.ui.BoxingViewFragment");
        if (this.mPickerFragment == null) {
            this.mPickerFragment = (BoxingViewFragment)BoxingViewFragment.newInstance().setSelectedBundle(medias);
            this.getSupportFragmentManager().beginTransaction().replace(R.id.content_layout, (Fragment)this.mPickerFragment, "com.bilibili.boxing_impl.ui.BoxingViewFragment").commit();
        }
        return this.mPickerFragment;
    }

    private void createToolbar() {
        Toolbar bar = (Toolbar)this.findViewById(R.id.nav_top_bar);
        this.setSupportActionBar(bar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        bar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BoxingActivity.this.onBackPressed();
            }
        });
    }

    private void setTitleTxt(BoxingConfig config) {
        TextView titleTxt = (TextView)this.findViewById(R.id.pick_album_txt);
        if (config.getMode() == BoxingConfig.Mode.VIDEO) {
            titleTxt.setText(R.string.boxing_video_title);
            titleTxt.setCompoundDrawables(null, null, null, null);
            return;
        }
        this.mPickerFragment.setTitleTxt(titleTxt);
    }

    public void onBoxingFinish(Intent intent, @Nullable List<BaseMedia> medias) {
        this.setResult(-1, intent);
        this.finish();
    }
}

