/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bilibili.boxing.model.BoxingManager;
import com.bilibili.boxing.model.config.BoxingConfig;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing_impl.BoxingResHelper;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.view.MediaItemLayout;
import java.util.ArrayList;
import java.util.List;

public class BoxingMediaAdapter
extends RecyclerView.Adapter {
    private static final int CAMERA_TYPE = 0;
    private static final int NORMAL_TYPE = 1;
    private int mOffset;
    private boolean mMultiImageMode;
    private List<BaseMedia> mMedias;
    private List<BaseMedia> mSelectedMedias;
    private LayoutInflater mInflater;
    private BoxingConfig mMediaConfig;
    private View.OnClickListener mOnCameraClickListener;
    private View.OnClickListener mOnMediaClickListener;
    private OnCheckListener mOnCheckListener;
    private OnMediaCheckedListener mOnCheckedListener;
    private int mDefaultRes;

    public BoxingMediaAdapter(Context context) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mMedias = new ArrayList<BaseMedia>();
        this.mSelectedMedias = new ArrayList<BaseMedia>();
        this.mMediaConfig = BoxingManager.getInstance().getBoxingConfig();
        this.mOffset = this.mMediaConfig.isNeedCamera() ? 1 : 0;
        this.mMultiImageMode = this.mMediaConfig.getMode() == BoxingConfig.Mode.MULTI_IMG;
        this.mOnCheckListener = new OnCheckListener();
        this.mDefaultRes = this.mMediaConfig.getMediaPlaceHolderRes();
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.mMediaConfig.isNeedCamera()) {
            return 0;
        }
        return 1;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (0 == viewType) {
            return new CameraViewHolder(this.mInflater.inflate(R.layout.layout_boxing_recycleview_header, parent, false));
        }
        return new ImageViewHolder(this.mInflater.inflate(R.layout.layout_boxing_recycleview_item, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof CameraViewHolder) {
            CameraViewHolder viewHolder = (CameraViewHolder)holder;
            viewHolder.mCameraLayout.setOnClickListener(this.mOnCameraClickListener);
            viewHolder.mCameraImg.setImageResource(BoxingResHelper.getCameraRes());
        } else {
            int pos = position - this.mOffset;
            BaseMedia media = this.mMedias.get(pos);
            ImageViewHolder vh = (ImageViewHolder)holder;
            vh.mItemLayout.setImageRes(this.mDefaultRes);
            vh.mItemLayout.setTag(media);
            vh.mItemLayout.setOnClickListener(this.mOnMediaClickListener);
            vh.mItemLayout.setTag(R.id.media_item_check, pos);
            vh.mItemLayout.setMedia(media);
            vh.mItemChecked.setVisibility(this.mMultiImageMode ? 0 : 8);
            if (this.mMultiImageMode && media instanceof ImageMedia) {
                vh.mItemLayout.setChecked(((ImageMedia)media).isSelected());
                vh.mItemChecked.setTag(R.id.media_layout, (Object)vh.mItemLayout);
                vh.mItemChecked.setTag((Object)media);
                vh.mItemChecked.setOnClickListener((View.OnClickListener)this.mOnCheckListener);
            }
        }
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mMedias.size() + this.mOffset;
    }

    public void setOnCameraClickListener(View.OnClickListener onCameraClickListener) {
        this.mOnCameraClickListener = onCameraClickListener;
    }

    public void setOnCheckedListener(OnMediaCheckedListener onCheckedListener) {
        this.mOnCheckedListener = onCheckedListener;
    }

    public void setOnMediaClickListener(View.OnClickListener onMediaClickListener) {
        this.mOnMediaClickListener = onMediaClickListener;
    }

    public List<BaseMedia> getSelectedMedias() {
        return this.mSelectedMedias;
    }

    public void setSelectedMedias(List<BaseMedia> selectedMedias) {
        if (selectedMedias == null) {
            return;
        }
        this.mSelectedMedias.clear();
        this.mSelectedMedias.addAll(selectedMedias);
    }

    public void addAllData(@NonNull List<BaseMedia> data) {
        this.mMedias.addAll(data);
        if (this.getItemViewType(0) == 0) {
            this.notifyItemRangeInserted(1, this.mMedias.size());
        } else {
            this.notifyItemRangeInserted(0, this.mMedias.size());
        }
    }

    public void clearData() {
        int size = this.mMedias.size();
        this.mMedias.clear();
        if (this.getItemViewType(0) == 0) {
            this.notifyItemRangeRemoved(1, size);
        } else {
            this.notifyItemRangeRemoved(0, size);
        }
    }

    public List<BaseMedia> getAllMedias() {
        return this.mMedias;
    }

    public static interface OnMediaCheckedListener {
        public void onChecked(View var1, BaseMedia var2);
    }

    private class OnCheckListener
    implements View.OnClickListener {
        private OnCheckListener() {
        }

        public void onClick(View v) {
            MediaItemLayout itemLayout = (MediaItemLayout)((Object)v.getTag(R.id.media_layout));
            BaseMedia media = (BaseMedia)v.getTag();
            if (BoxingMediaAdapter.this.mMediaConfig.getMode() == BoxingConfig.Mode.MULTI_IMG && BoxingMediaAdapter.this.mOnCheckedListener != null) {
                BoxingMediaAdapter.this.mOnCheckedListener.onChecked((View)itemLayout, media);
            }
        }
    }

    private static class CameraViewHolder
    extends RecyclerView.ViewHolder {
        View mCameraLayout;
        ImageView mCameraImg;

        CameraViewHolder(View itemView) {
            super(itemView);
            this.mCameraLayout = itemView.findViewById(R.id.camera_layout);
            this.mCameraImg = (ImageView)itemView.findViewById(R.id.camera_img);
        }
    }

    private static class ImageViewHolder
    extends RecyclerView.ViewHolder {
        MediaItemLayout mItemLayout;
        View mItemChecked;

        ImageViewHolder(View itemView) {
            super(itemView);
            this.mItemLayout = (MediaItemLayout)itemView.findViewById(R.id.media_layout);
            this.mItemChecked = itemView.findViewById(R.id.media_item_check);
        }
    }
}

