/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.configuration;

import com.github.xiaoymin.knife4j.core.conf.GlobalConstants;
import com.github.xiaoymin.knife4j.core.enums.OpenAPILanguageEnums;
import com.github.xiaoymin.knife4j.core.extend.OpenApiExtendSetting;
import com.github.xiaoymin.knife4j.spring.common.bean.Knife4jDocketAutoRegistry;
import com.github.xiaoymin.knife4j.spring.common.bean.Knife4jI18nServiceModelToSwagger2MapperImpl;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jHttpBasic;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jInfoProperties;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jProperties;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jSetting;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.model.docket.Knife4jAuthInfoProperties;
import com.github.xiaoymin.knife4j.spring.util.EnvironmentUtils;
import java.util.Arrays;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Configuration
@EnableConfigurationProperties(value={Knife4jProperties.class, Knife4jInfoProperties.class, Knife4jHttpBasic.class, Knife4jSetting.class, Knife4jAuthInfoProperties.class})
@ConditionalOnProperty(name={"knife4j.enable"}, havingValue="true")
public class Knife4jAutoConfiguration {
    private final Environment environment;
    Logger logger = LoggerFactory.getLogger(Knife4jAutoConfiguration.class);

    public Knife4jAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean(value={"knife4jCorsFilter"})
    @ConditionalOnMissingBean(value={CorsFilter.class})
    @ConditionalOnProperty(name={"knife4j.cors"}, havingValue="true")
    public CorsFilter corsFilter() {
        this.logger.info("init CorsFilter...");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setAllowedOriginPatterns(Arrays.asList("*"));
        corsConfiguration.setMaxAge(GlobalConstants.CORS_MAX_AGE);
        source.registerCorsConfiguration("/**", corsConfiguration);
        CorsFilter corsFilter = new CorsFilter((CorsConfigurationSource)source);
        return corsFilter;
    }

    @Bean(initMethod="start")
    @ConditionalOnMissingBean(value={OpenApiExtensionResolver.class})
    @ConditionalOnProperty(name={"knife4j.enable"}, havingValue="true")
    public OpenApiExtensionResolver markdownResolver(Knife4jProperties knife4jProperties) {
        Knife4jSetting setting = knife4jProperties.getSetting();
        if (setting == null) {
            setting = new Knife4jSetting();
        }
        OpenApiExtendSetting extendSetting = new OpenApiExtendSetting();
        BeanUtils.copyProperties((Object)setting, (Object)extendSetting);
        extendSetting.setLanguage(setting.getLanguage().getValue());
        return new OpenApiExtensionResolver(extendSetting, knife4jProperties.getDocuments());
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityBasicAuthFilter.class})
    @ConditionalOnProperty(name={"knife4j.basic.enable"}, havingValue="true")
    public SecurityBasicAuthFilter securityBasicAuthFilter(Knife4jProperties knife4jProperties) {
        SecurityBasicAuthFilter securityBasicAuthFilter = null;
        securityBasicAuthFilter = knife4jProperties == null ? new SecurityBasicAuthFilter(EnvironmentUtils.resolveBool(this.environment, "knife4j.basic.enable", Boolean.FALSE), EnvironmentUtils.resolveString(this.environment, "knife4j.basic.username", "admin"), EnvironmentUtils.resolveString(this.environment, "knife4j.basic.password", "123321")) : (knife4jProperties.getBasic() == null ? new SecurityBasicAuthFilter(Boolean.FALSE, "admin", "123321") : new SecurityBasicAuthFilter(knife4jProperties.getBasic().isEnable(), knife4jProperties.getBasic().getUsername(), knife4jProperties.getBasic().getPassword()));
        return securityBasicAuthFilter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProductionSecurityFilter.class})
    @ConditionalOnProperty(name={"knife4j.production"}, havingValue="true")
    public ProductionSecurityFilter productionSecurityFilter(Knife4jProperties knife4jProperties) {
        ProductionSecurityFilter p = null;
        if (knife4jProperties == null) {
            int customCode = EnvironmentUtils.resolveInt(this.environment, "knife4j.setting.custom-code", 200);
            boolean prod = EnvironmentUtils.resolveBool(this.environment, "knife4j.production", Boolean.FALSE);
            p = new ProductionSecurityFilter(prod, customCode);
        } else {
            p = new ProductionSecurityFilter(knife4jProperties.isProduction(), knife4jProperties.getSetting().getCustomCode());
        }
        return p;
    }

    @ComponentScan(basePackages={"com.github.xiaoymin.knife4j.spring.plugin", "com.github.xiaoymin.knife4j.spring.common"})
    @EnableSwagger2WebMvc
    public class Knife4jEnhanceAutoConfiguration {
        @Bean
        @Qualifier(value="knife4jDocketAutoRegistry")
        public Knife4jDocketAutoRegistry knife4jDocketAutoRegistry(Knife4jProperties knife4jProperties, OpenApiExtensionResolver openApiExtensionResolver) {
            return new Knife4jDocketAutoRegistry(knife4jProperties, openApiExtensionResolver);
        }

        @Bean
        @ConditionalOnBean(value={MessageSource.class})
        @Qualifier(value="ServiceModelToSwagger2Mapper")
        @Primary
        public Knife4jI18nServiceModelToSwagger2MapperImpl knife4jI18nServiceModelToSwagger2Mapper(Knife4jProperties knife4jProperties, MessageSource messageSource, ModelMapper modelMapper, ParameterMapper parameterMapper, SecurityMapper securityMapper, LicenseMapper licenseMapper, VendorExtensionsMapper vendorExtensionsMapper) {
            String language = OpenAPILanguageEnums.ZH_CN.getValue();
            if (knife4jProperties.getSetting() != null) {
                language = knife4jProperties.getSetting().getLanguage().getValue();
            }
            Locale locale = Locale.forLanguageTag(language);
            return new Knife4jI18nServiceModelToSwagger2MapperImpl(messageSource, locale, modelMapper, parameterMapper, securityMapper, licenseMapper, vendorExtensionsMapper);
        }
    }
}

