/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.disk.DiskRoute;
import com.github.xiaoymin.knife4j.aggre.repository.AbsctractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.DiskSetting;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class DiskRepository
extends AbsctractRepository {
    Logger logger = LoggerFactory.getLogger(DiskRepository.class);
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();

    public DiskRepository(DiskSetting diskSetting) {
        if (diskSetting != null && CollectionUtil.isNotEmpty(diskSetting.getRoutes())) {
            this.init(diskSetting);
        }
    }

    private void init(DiskSetting diskSetting) {
        for (DiskRoute diskRoute : diskSetting.getRoutes()) {
            if (!StrUtil.isNotBlank((CharSequence)diskRoute.getLocation())) continue;
            try {
                InputStream resource = this.getResource(diskRoute.getLocation());
                if (resource == null) continue;
                String content = new String(this.readBytes(resource), "UTF-8");
                this.routeMap.put(diskRoute.pkId(), new SwaggerRoute(diskRoute, content));
            }
            catch (Exception e) {
                this.logger.error("read err:" + e.getMessage());
            }
        }
    }

    private InputStream getResource(String location) {
        InputStream resource = null;
        try {
            Resource[] resources = this.resourceResolver.getResources(location);
            resource = resources != null && resources.length > 0 ? resources[0].getInputStream() : new FileSystemResource(new File(location)).getInputStream();
        }
        catch (Exception e) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("read from resource error:" + e.getMessage());
                    this.logger.debug("read from local file:{}", (Object)location);
                }
                resource = new FileSystemResource(new File(location)).getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resource;
    }

    private byte[] readBytes(InputStream ins) {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream byteOutArr = new ByteArrayOutputStream();
        int r = -1;
        byte[] bytes = new byte[0x100000];
        try {
            while ((r = ins.read(bytes)) != -1) {
                byteOutArr.write(bytes, 0, r);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtil.close((Closeable)ins);
        }
        return byteOutArr.toByteArray();
    }
}

