/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.support;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.error.RouterRuntimeException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class Utils {
    public static final AtomicInteger COUNTER = new AtomicInteger(0);
    private static final String STR_PARAMETER = "parameter '";
    private static final String STR_CAN_NOT_BE_NULL = "' can't be null";
    private static final String MAIN_THREAD_ERROR_MSG = "Component mainThreadCall method timeout, A deadlock was happened. see: https://github.com/xiaojinzi123/Component/issues/79";
    private static final long MAIN_THREAD_TIME_OUT = 3000L;
    private static final ExecutorService workPool = Executors.newSingleThreadExecutor();
    private static Handler h = new Handler(Looper.getMainLooper());

    private Utils() {
    }

    @AnyThread
    public static void postDelayActionToMainThread(@NonNull @UiThread Runnable r, long delayMillis) {
        h.postDelayed(r, delayMillis);
    }

    @AnyThread
    public static void postActionToWorkThread(@NonNull Runnable r) {
        workPool.submit(r);
    }

    @AnyThread
    public static void postActionToMainThread(@NonNull Runnable r) {
        if (Utils.isMainThread()) {
            r.run();
        } else {
            h.post(r);
        }
    }

    public static void postActionToMainThreadAnyway(@NonNull Runnable r) {
        h.post(r);
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static boolean isActivityDestoryed(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            return activity.isFinishing() || activity.isDestroyed();
        }
        return activity.isFinishing();
    }

    @Nullable
    public static String getRealMessage(@NonNull Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable.getMessage();
    }

    @NonNull
    public static Throwable getRealThrowable(@NonNull Throwable throwable) {
        Utils.checkNullPointer(throwable);
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static boolean isCauseBy(@NonNull Throwable throwable, @NonNull Class<? extends Throwable> clazz) {
        Utils.checkNullPointer(throwable);
        if (throwable.getClass() == clazz) {
            return true;
        }
        while (throwable.getCause() != null) {
            if ((throwable = throwable.getCause()).getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static String checkStringNullPointer(@Nullable String value, @NonNull String parameterName) {
        return Utils.checkStringNullPointer(value, parameterName, null);
    }

    public static String checkStringNullPointer(@Nullable String value, @NonNull String parameterName, @Nullable String desc) {
        if (value == null || value.isEmpty()) {
            throw new NullPointerException(STR_PARAMETER + parameterName + STR_CAN_NOT_BE_NULL + (desc == null ? "" : "," + desc));
        }
        return value;
    }

    public static <T> T checkNullPointer(@Nullable T value) {
        if (Component.isDebug() && value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> T checkNullPointer(@Nullable T value, @NonNull String parameterName) {
        if (Component.isDebug() && value == null) {
            throw new NullPointerException(STR_PARAMETER + parameterName + STR_CAN_NOT_BE_NULL);
        }
        return value;
    }

    public static <T> T debugCheckNullPointer(@Nullable T value, @NonNull String parameterName) {
        if (Component.isDebug() && value == null) {
            throw new NullPointerException(STR_PARAMETER + parameterName + STR_CAN_NOT_BE_NULL);
        }
        return value;
    }

    public static boolean isLowMemoryDevice(@NonNull ActivityManager activityManager) {
        if (Build.VERSION.SDK_INT >= 19) {
            return activityManager.isLowRamDevice();
        }
        return true;
    }

    @Nullable
    public static Activity getActivityFromContext(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        Activity realActivity = null;
        if (context instanceof Activity) {
            realActivity = (Activity)context;
        } else {
            Context realContext = context;
            while (realContext instanceof ContextWrapper) {
                if (!((realContext = ((ContextWrapper)realContext).getBaseContext()) instanceof Activity)) continue;
                realActivity = (Activity)realContext;
                break;
            }
        }
        return realActivity;
    }

    public static void debugThrowException(@NonNull RuntimeException e) {
        if (Component.isDebug()) {
            throw e;
        }
    }

    public static void checkMainThread() {
        if (!Utils.isMainThread()) {
            throw new RouterRuntimeException("the thread is not main thread!");
        }
    }
}

