/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.support;

import android.support.annotation.NonNull;
import com.xiaojinzi.component.impl.Navigator;
import com.xiaojinzi.component.impl.RouterInterceptor;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.impl.RouterResult;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.List;

public class RetryRouterInterceptor
implements RouterInterceptor {
    @NonNull
    private RouterInterceptor target;
    private int retryCount;

    public RetryRouterInterceptor(@NonNull RouterInterceptor target, int retryCount) {
        Utils.checkNullPointer(target);
        this.target = target;
        this.retryCount = retryCount;
    }

    @Override
    public void intercept(final @NonNull RouterInterceptor.Chain outChain) throws Exception {
        RouterInterceptor.Callback outCallback = outChain.callback();
        ArrayList<RouterInterceptor> retryList = new ArrayList<RouterInterceptor>(this.retryCount + 1);
        for (int i = 0; i < this.retryCount; ++i) {
            retryList.add(this.target);
        }
        retryList.add(new RouterInterceptor(){

            @Override
            public void intercept(@NonNull RouterInterceptor.Chain chain) throws Exception {
                outChain.proceed(chain.request());
            }
        });
        RetryInterceptorChain retryChain = new RetryInterceptorChain(retryList, 0, outChain.request(), outCallback);
        retryChain.proceed(outChain.request());
    }

    private class RetryInterceptorChain
    extends Navigator.InterceptorChain {
        private RouterInterceptor.Callback mRetryCallback;

        public RetryInterceptorChain(List<RouterInterceptor> interceptors, @NonNull int index, @NonNull RouterRequest request, RouterInterceptor.Callback callback) {
            super(interceptors, index, request, callback);
            this.mRetryCallback = new RouterInterceptor.Callback(){

                @Override
                public void onSuccess(@NonNull RouterResult result) {
                    RetryInterceptorChain.this.rawCallback().onSuccess(result);
                }

                @Override
                public void onError(@NonNull Throwable error) {
                    if (RetryInterceptorChain.this.index() == RetryInterceptorChain.this.interceptors().size() - 2) {
                        RetryInterceptorChain.this.rawCallback().onError(error);
                    } else {
                        RetryInterceptorChain retryChain = new RetryInterceptorChain(RetryInterceptorChain.this.interceptors(), RetryInterceptorChain.this.index() + 1, RetryInterceptorChain.this.request(), RetryInterceptorChain.this.rawCallback());
                        retryChain.proceed(RetryInterceptorChain.this.request());
                    }
                }

                @Override
                public boolean isComplete() {
                    return RetryInterceptorChain.this.rawCallback().isComplete();
                }

                @Override
                public boolean isCanceled() {
                    return RetryInterceptorChain.this.rawCallback().isCanceled();
                }

                @Override
                public boolean isEnd() {
                    return RetryInterceptorChain.this.rawCallback().isEnd();
                }
            };
        }

        @Override
        public RouterInterceptor.Callback callback() {
            return this.mRetryCallback;
        }
    }
}

