/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.support;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.xiaojinzi.component.support.Function;
import com.xiaojinzi.component.support.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ParameterSupport {
    public static final String KEY_URI_QUERY_BUNDLE = "_componentQueryBundle";
    public static final String KEY_URI = "_componentRouterUri";

    private ParameterSupport() {
    }

    public static void syncUriToBundle(@NonNull Uri uri, @NonNull Bundle bundle) {
        Utils.checkNullPointer(uri, "uri");
        Utils.checkNullPointer(bundle, "bundle");
        Bundle routerParameterBundle = new Bundle();
        Set queryParameterNames = uri.getQueryParameterNames();
        if (queryParameterNames != null) {
            for (String key : queryParameterNames) {
                List values = uri.getQueryParameters(key);
                routerParameterBundle.putStringArrayList(key, new ArrayList(values));
            }
        }
        bundle.putBundle(KEY_URI_QUERY_BUNDLE, routerParameterBundle);
        bundle.putString(KEY_URI, uri.toString());
    }

    @Nullable
    public static Uri getUriIgnoreError(@NonNull Intent intent) {
        Utils.checkNullPointer(intent, "intent");
        try {
            String uriStr = ParameterSupport.getUriAsString(intent);
            return uriStr == null ? null : Uri.parse((String)uriStr);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public static Uri getUri(@NonNull Intent intent) {
        Utils.checkNullPointer(intent, "intent");
        String uriStr = ParameterSupport.getUriAsString(intent);
        return uriStr == null ? null : Uri.parse((String)uriStr);
    }

    @Nullable
    public static Uri getUriIgnoreError(@NonNull Bundle bundle) {
        Utils.checkNullPointer(bundle, "bundle");
        try {
            String uriStr = ParameterSupport.getUriAsString(bundle);
            return uriStr == null ? null : Uri.parse((String)uriStr);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public static Uri getUri(@NonNull Bundle bundle) {
        Utils.checkNullPointer(bundle, "bundle");
        String uriStr = ParameterSupport.getUriAsString(bundle);
        return uriStr == null ? null : Uri.parse((String)uriStr);
    }

    @Nullable
    public static String getUriAsString(@NonNull Bundle bundle) {
        Utils.checkNullPointer(bundle, "bundle");
        return bundle.getString(KEY_URI);
    }

    @Nullable
    public static String getUriAsString(@NonNull Intent intent) {
        Utils.checkNullPointer(intent, "intent");
        if (intent.getExtras() == null) {
            return null;
        }
        return intent.getExtras().getString(KEY_URI);
    }

    public static boolean containsKey(@NonNull Bundle bundle, @NonNull String key) {
        Utils.checkNullPointer(bundle, "bundle");
        Utils.checkStringNullPointer(key, "key");
        return bundle.getBundle(KEY_URI_QUERY_BUNDLE) != null && bundle.getBundle(KEY_URI_QUERY_BUNDLE).containsKey(key) || bundle.containsKey(key);
    }

    @Nullable
    public static <T> List<T> getQuerys(@Nullable Bundle bundle, @NonNull String key, @NonNull Function<String, T> function) {
        if (bundle == null) {
            return null;
        }
        Bundle routerParameterBundle = bundle.getBundle(KEY_URI_QUERY_BUNDLE);
        if (routerParameterBundle == null) {
            return null;
        }
        ArrayList values = routerParameterBundle.getStringArrayList(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        try {
            ArrayList<T> result = new ArrayList<T>(values.size());
            for (String value : values) {
                result.add(function.apply(value));
            }
            return result;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public static String getQueryString(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryString(intent, key, null);
    }

    @Nullable
    public static String getQueryString(@NonNull Intent intent, @NonNull String key, @Nullable String defaultValue) {
        return ParameterSupport.getQueryString(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static String getQueryString(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryString(bundle, key, null);
    }

    @Nullable
    public static String getQueryString(@Nullable Bundle bundle, @NonNull String key, @Nullable String defaultValue) {
        List<String> values = ParameterSupport.getQueryStrings(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<String> getQueryStrings(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryStrings(intent.getExtras(), key);
    }

    @Nullable
    public static List<String> getQueryStrings(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, String>(){

            @Override
            @NonNull
            public String apply(@NonNull String s) throws Exception {
                return s;
            }
        });
    }

    @Nullable
    public static Integer getQueryInt(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryInt(intent, key, null);
    }

    @Nullable
    public static Integer getQueryInt(@NonNull Intent intent, @NonNull String key, @Nullable Integer defaultValue) {
        return ParameterSupport.getQueryInt(intent.getExtras(), key, defaultValue);
    }

    public static Integer getQueryInt(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryInt(bundle, key, null);
    }

    @Nullable
    public static Integer getQueryInt(@Nullable Bundle bundle, @NonNull String key, @Nullable Integer defaultValue) {
        List<Integer> values = ParameterSupport.getQueryInts(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Integer> getQueryInts(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryInts(intent.getExtras(), key);
    }

    @Nullable
    public static List<Integer> getQueryInts(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Integer>(){

            @Override
            @NonNull
            public Integer apply(@NonNull String s) throws Exception {
                return Integer.parseInt(s);
            }
        });
    }

    @Nullable
    public static Long getQueryLong(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryLong(intent, key, null);
    }

    @Nullable
    public static Long getQueryLong(@NonNull Intent intent, @NonNull String key, @Nullable Long defaultValue) {
        return ParameterSupport.getQueryLong(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Long getQueryLong(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryLong(bundle, key, null);
    }

    @Nullable
    public static Long getQueryLong(@Nullable Bundle bundle, @NonNull String key, @Nullable Long defaultValue) {
        List<Long> values = ParameterSupport.getQueryLongs(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Long> getQueryLongs(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryLongs(intent.getExtras(), key);
    }

    @Nullable
    public static List<Long> getQueryLongs(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Long>(){

            @Override
            @NonNull
            public Long apply(@NonNull String s) throws Exception {
                return Long.parseLong(s);
            }
        });
    }

    @Nullable
    public static Double getQueryDouble(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryDouble(intent, key, null);
    }

    @Nullable
    public static Double getQueryDouble(@NonNull Intent intent, @NonNull String key, @Nullable Double defaultValue) {
        return ParameterSupport.getQueryDouble(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Double getQueryDouble(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryDouble(bundle, key, null);
    }

    @Nullable
    public static Double getQueryDouble(@Nullable Bundle bundle, @NonNull String key, @Nullable Double defaultValue) {
        List<Double> values = ParameterSupport.getQueryDoubles(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Double> getQueryDoubles(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryDoubles(intent.getExtras(), key);
    }

    @Nullable
    public static List<Double> getQueryDoubles(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Double>(){

            @Override
            @NonNull
            public Double apply(@NonNull String s) throws Exception {
                return Double.parseDouble(s);
            }
        });
    }

    @Nullable
    public static Float getQueryFloat(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryFloat(intent, key, null);
    }

    @Nullable
    public static Float getQueryFloat(@NonNull Intent intent, @NonNull String key, @Nullable Float defaultValue) {
        return ParameterSupport.getQueryFloat(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Float getQueryFloat(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryFloat(bundle, key, null);
    }

    @Nullable
    public static Float getQueryFloat(@Nullable Bundle bundle, @NonNull String key, @Nullable Float defaultValue) {
        List<Float> values = ParameterSupport.getQueryFloats(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Float> getQueryFloats(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryFloats(intent.getExtras(), key);
    }

    @Nullable
    public static List<Float> getQueryFloats(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Float>(){

            @Override
            @NonNull
            public Float apply(@NonNull String s) throws Exception {
                return Float.valueOf(Float.parseFloat(s));
            }
        });
    }

    @Nullable
    public static Boolean getQueryBoolean(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryBoolean(intent, key, null);
    }

    @Nullable
    public static Boolean getQueryBoolean(@NonNull Intent intent, @NonNull String key, @Nullable Boolean defaultValue) {
        return ParameterSupport.getQueryBoolean(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Boolean getQueryBoolean(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryBoolean(bundle, key, null);
    }

    @Nullable
    public static Boolean getQueryBoolean(@Nullable Bundle bundle, @NonNull String key, @Nullable Boolean defaultValue) {
        List<Boolean> values = ParameterSupport.getQueryBooleans(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Boolean> getQueryBooleans(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryBooleans(intent.getExtras(), key);
    }

    @Nullable
    public static List<Boolean> getQueryBooleans(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Boolean>(){

            @Override
            @NonNull
            public Boolean apply(@NonNull String s) throws Exception {
                return Boolean.parseBoolean(s);
            }
        });
    }

    @Nullable
    public static Short getQueryShort(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryShort(intent, key, null);
    }

    @Nullable
    public static Short getQueryShort(@NonNull Intent intent, @NonNull String key, @Nullable Short defaultValue) {
        return ParameterSupport.getQueryShort(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Short getQueryShort(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryShort(bundle, key, null);
    }

    @Nullable
    public static Short getQueryShort(@Nullable Bundle bundle, @NonNull String key, @Nullable Short defaultValue) {
        List<Short> values = ParameterSupport.getQueryShorts(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Short> getQueryShorts(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryShorts(intent.getExtras(), key);
    }

    @Nullable
    public static List<Short> getQueryShorts(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Short>(){

            @Override
            @NonNull
            public Short apply(@NonNull String s) throws Exception {
                return Short.parseShort(s);
            }
        });
    }

    @Nullable
    public static Byte getQueryByte(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryByte(intent, key, null);
    }

    @Nullable
    public static Byte getQueryByte(@NonNull Intent intent, @NonNull String key, @Nullable Byte defaultValue) {
        return ParameterSupport.getQueryByte(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Byte getQueryByte(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryByte(bundle, key, null);
    }

    @Nullable
    public static Byte getQueryByte(@Nullable Bundle bundle, @NonNull String key, @Nullable Byte defaultValue) {
        List<Byte> values = ParameterSupport.getQueryBytes(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Byte> getQueryBytes(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryBytes(intent.getExtras(), key);
    }

    @Nullable
    public static List<Byte> getQueryBytes(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Byte>(){

            @Override
            @NonNull
            public Byte apply(@NonNull String s) throws Exception {
                return Byte.parseByte(s);
            }
        });
    }

    @Nullable
    public static Character getQueryChar(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryChar(intent, key, null);
    }

    @Nullable
    public static Character getQueryChar(@NonNull Intent intent, @NonNull String key, @Nullable Character defaultValue) {
        return ParameterSupport.getQueryChar(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Character getQueryChar(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQueryChar(bundle, key, null);
    }

    @Nullable
    public static Character getQueryChar(@Nullable Bundle bundle, @NonNull String key, @Nullable Character defaultValue) {
        List<Character> values = ParameterSupport.getQueryChars(bundle, key);
        if (values == null) {
            return defaultValue;
        }
        return values.get(0);
    }

    @NonNull
    public static List<Character> getQueryChars(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getQueryChars(intent.getExtras(), key);
    }

    @Nullable
    public static List<Character> getQueryChars(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getQuerys(bundle, key, new Function<String, Character>(){

            @Override
            @NonNull
            public Character apply(@NonNull String s) throws Exception {
                if (s.length() == 1) {
                    return Character.valueOf(s.charAt(0));
                }
                throw new IllegalArgumentException(s + " is not a Character");
            }
        });
    }

    @Nullable
    public static String getString(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getString(intent, key, null);
    }

    @Nullable
    public static String getString(@NonNull Intent intent, @NonNull String key, @Nullable String defaultValue) {
        return ParameterSupport.getString(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static String getString(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getString(bundle, key, null);
    }

    @Nullable
    public static String getString(@Nullable Bundle bundle, @NonNull String key, @Nullable String defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        String value = ParameterSupport.getQueryString(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getString(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static ArrayList<String> getStringArrayList(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getStringArrayList(intent, key, null);
    }

    @Nullable
    public static ArrayList<String> getStringArrayList(@NonNull Intent intent, @NonNull String key, ArrayList<String> defaultValue) {
        return ParameterSupport.getStringArrayList(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static ArrayList<String> getStringArrayList(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getStringArrayList(bundle, key, null);
    }

    @Nullable
    public static ArrayList<String> getStringArrayList(@Nullable Bundle bundle, @NonNull String key, @Nullable ArrayList<String> defaultValue) {
        ArrayList<Object> value;
        if (bundle == null) {
            return defaultValue;
        }
        List<String> queryValues = ParameterSupport.getQueryStrings(bundle, key);
        ArrayList<Object> arrayList = value = queryValues == null ? null : new ArrayList(queryValues);
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getStringArrayList(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Integer getInt(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getInt(intent, key, null);
    }

    @Nullable
    public static Integer getInt(@NonNull Intent intent, @NonNull String key, @Nullable Integer defaultValue) {
        return ParameterSupport.getInt(intent.getExtras(), key, defaultValue);
    }

    public static Integer getInt(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getInt(bundle, key, null);
    }

    @Nullable
    public static Integer getInt(@Nullable Bundle bundle, @NonNull String key, @Nullable Integer defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Integer value = null;
        value = ParameterSupport.getQueryInt(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Integer.valueOf(bundle.getInt(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static ArrayList<Integer> getIntegerArrayList(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getIntegerArrayList(intent, key, null);
    }

    @Nullable
    public static ArrayList<Integer> getIntegerArrayList(@NonNull Intent intent, @NonNull String key, ArrayList<Integer> defaultValue) {
        return ParameterSupport.getIntegerArrayList(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static ArrayList<Integer> getIntegerArrayList(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getIntegerArrayList(bundle, key, null);
    }

    @Nullable
    public static ArrayList<Integer> getIntegerArrayList(@Nullable Bundle bundle, @NonNull String key, @Nullable ArrayList<Integer> defaultValue) {
        ArrayList<Object> value;
        if (bundle == null) {
            return defaultValue;
        }
        List<Integer> queryValues = ParameterSupport.getQueryInts(bundle, key);
        ArrayList<Object> arrayList = value = queryValues == null ? null : new ArrayList(queryValues);
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getIntegerArrayList(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Long getLong(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getLong(intent, key, null);
    }

    @Nullable
    public static Long getLong(@NonNull Intent intent, @NonNull String key, @Nullable Long defaultValue) {
        return ParameterSupport.getLong(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Long getLong(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getLong(bundle, key, null);
    }

    @Nullable
    public static Long getLong(@Nullable Bundle bundle, @NonNull String key, @Nullable Long defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Long value = null;
        value = ParameterSupport.getQueryLong(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Long.valueOf(bundle.getLong(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Double getDouble(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getDouble(intent, key, null);
    }

    @Nullable
    public static Double getDouble(@NonNull Intent intent, @NonNull String key, @Nullable Double defaultValue) {
        return ParameterSupport.getDouble(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Double getDouble(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getDouble(bundle, key, null);
    }

    @Nullable
    public static Double getDouble(@Nullable Bundle bundle, @NonNull String key, @Nullable Double defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Double value = null;
        value = ParameterSupport.getQueryDouble(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Double.valueOf(bundle.getDouble(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static CharSequence getCharSequence(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getCharSequence(intent, key, null);
    }

    @Nullable
    public static CharSequence getCharSequence(@NonNull Intent intent, @NonNull String key, @Nullable CharSequence defaultValue) {
        return ParameterSupport.getCharSequence(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static CharSequence getCharSequence(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getCharSequence(bundle, key, null);
    }

    @Nullable
    public static CharSequence getCharSequence(@Nullable Bundle bundle, @NonNull String key, @Nullable CharSequence defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        CharSequence value = null;
        value = bundle.containsKey(key) ? bundle.getCharSequence(key) : defaultValue;
        return value;
    }

    @Nullable
    public static Byte getByte(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getByte(intent, key, null);
    }

    @Nullable
    public static Byte getByte(@NonNull Intent intent, @NonNull String key, @Nullable Byte defaultValue) {
        return ParameterSupport.getByte(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Byte getByte(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getByte(bundle, key, null);
    }

    @Nullable
    public static Byte getByte(@Nullable Bundle bundle, @NonNull String key, @Nullable Byte defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Byte value = null;
        value = ParameterSupport.getQueryByte(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Byte.valueOf(bundle.getByte(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Character getChar(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getChar(intent, key, null);
    }

    @Nullable
    public static Character getChar(@NonNull Intent intent, @NonNull String key, @Nullable Character defaultValue) {
        return ParameterSupport.getChar(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Character getChar(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getChar(bundle, key, null);
    }

    @Nullable
    public static Character getChar(@Nullable Bundle bundle, @NonNull String key, @Nullable Character defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Character value = null;
        value = ParameterSupport.getQueryChar(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Character.valueOf(bundle.getChar(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Float getFloat(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getFloat(intent, key, null);
    }

    @Nullable
    public static Float getFloat(@NonNull Intent intent, @NonNull String key, @Nullable Float defaultValue) {
        return ParameterSupport.getFloat(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Float getFloat(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getFloat(bundle, key, null);
    }

    @Nullable
    public static Float getFloat(@Nullable Bundle bundle, @NonNull String key, @Nullable Float defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Float value = null;
        value = ParameterSupport.getQueryFloat(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Float.valueOf(bundle.getFloat(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Short getShort(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getShort(intent, key, null);
    }

    @Nullable
    public static Short getShort(@NonNull Intent intent, @NonNull String key, @Nullable Short defaultValue) {
        return ParameterSupport.getShort(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Short getShort(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getShort(bundle, key, null);
    }

    @Nullable
    public static Short getShort(@Nullable Bundle bundle, @NonNull String key, @Nullable Short defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Short value = null;
        value = ParameterSupport.getQueryShort(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Short.valueOf(bundle.getShort(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Boolean getBoolean(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getBoolean(intent, key, null);
    }

    @Nullable
    public static Boolean getBoolean(@NonNull Intent intent, @NonNull String key, @Nullable Boolean defaultValue) {
        return ParameterSupport.getBoolean(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Boolean getBoolean(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getBoolean(bundle, key, null);
    }

    @Nullable
    public static Boolean getBoolean(@Nullable Bundle bundle, @NonNull String key, @Nullable Boolean defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Boolean value = null;
        value = ParameterSupport.getQueryBoolean(bundle, key, null);
        if (value == null) {
            value = bundle.containsKey(key) ? Boolean.valueOf(bundle.getBoolean(key)) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static String[] getStringArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getStringArray(intent, key, null);
    }

    @Nullable
    public static String[] getStringArray(@NonNull Intent intent, @NonNull String key, @Nullable String[] defaultValue) {
        return ParameterSupport.getStringArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static String[] getStringArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getStringArray(bundle, key, null);
    }

    @Nullable
    public static String[] getStringArray(@Nullable Bundle bundle, @NonNull String key, @Nullable String[] defaultValue) {
        String[] value;
        if (bundle == null) {
            return defaultValue;
        }
        List<String> queryValues = ParameterSupport.getQueryStrings(bundle, key);
        String[] stringArray = value = queryValues == null ? null : queryValues.toArray(new String[0]);
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getStringArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static CharSequence[] getCharSequenceArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getCharSequenceArray(intent, key, null);
    }

    @Nullable
    public static CharSequence[] getCharSequenceArray(@NonNull Intent intent, @NonNull String key, @Nullable CharSequence[] defaultValue) {
        return ParameterSupport.getCharSequenceArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static CharSequence[] getCharSequenceArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getCharSequenceArray(bundle, key, null);
    }

    @Nullable
    public static CharSequence[] getCharSequenceArray(@Nullable Bundle bundle, @NonNull String key, @Nullable CharSequence[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        CharSequence[] value = null;
        value = bundle.containsKey(key) ? bundle.getCharSequenceArray(key) : defaultValue;
        return value;
    }

    @Nullable
    public static boolean[] getBooleanArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getBooleanArray(intent, key, null);
    }

    @Nullable
    public static boolean[] getBooleanArray(@NonNull Intent intent, @NonNull String key, @Nullable boolean[] defaultValue) {
        return ParameterSupport.getBooleanArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static boolean[] getBooleanArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getBooleanArray(bundle, key, null);
    }

    @Nullable
    public static boolean[] getBooleanArray(@Nullable Bundle bundle, @NonNull String key, @Nullable boolean[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Boolean> queryValues = ParameterSupport.getQueryBooleans(bundle, key);
        boolean[] value = null;
        if (queryValues != null) {
            value = new boolean[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getBooleanArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static byte[] getByteArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getByteArray(intent, key, null);
    }

    @Nullable
    public static byte[] getByteArray(@NonNull Intent intent, @NonNull String key, @Nullable byte[] defaultValue) {
        return ParameterSupport.getByteArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static byte[] getByteArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getByteArray(bundle, key, null);
    }

    @Nullable
    public static byte[] getByteArray(@Nullable Bundle bundle, @NonNull String key, @Nullable byte[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Byte> queryValues = ParameterSupport.getQueryBytes(bundle, key);
        byte[] value = null;
        if (queryValues != null) {
            value = new byte[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getByteArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static char[] getCharArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getCharArray(intent, key, null);
    }

    @Nullable
    public static char[] getCharArray(@NonNull Intent intent, @NonNull String key, @Nullable char[] defaultValue) {
        return ParameterSupport.getCharArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static char[] getCharArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getCharArray(bundle, key, null);
    }

    @Nullable
    public static char[] getCharArray(@Nullable Bundle bundle, @NonNull String key, @Nullable char[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Character> queryValues = ParameterSupport.getQueryChars(bundle, key);
        char[] value = null;
        if (queryValues != null) {
            value = new char[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i).charValue();
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getCharArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static short[] getShortArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getShortArray(intent, key, null);
    }

    @Nullable
    public static short[] getShortArray(@NonNull Intent intent, @NonNull String key, @Nullable short[] defaultValue) {
        return ParameterSupport.getShortArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static short[] getShortArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getShortArray(bundle, key, null);
    }

    @Nullable
    public static short[] getShortArray(@Nullable Bundle bundle, @NonNull String key, @Nullable short[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Short> queryValues = ParameterSupport.getQueryShorts(bundle, key);
        short[] value = null;
        if (queryValues != null) {
            value = new short[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getShortArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static int[] getIntArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getIntArray(intent, key, null);
    }

    @Nullable
    public static int[] getIntArray(@NonNull Intent intent, @NonNull String key, @Nullable int[] defaultValue) {
        return ParameterSupport.getIntArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static int[] getIntArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getIntArray(bundle, key, null);
    }

    @Nullable
    public static int[] getIntArray(@Nullable Bundle bundle, @NonNull String key, @Nullable int[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Integer> queryValues = ParameterSupport.getQueryInts(bundle, key);
        int[] value = null;
        if (queryValues != null) {
            value = new int[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getIntArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static long[] getLongArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getLongArray(intent, key, null);
    }

    @Nullable
    public static long[] getLongArray(@NonNull Intent intent, @NonNull String key, @Nullable long[] defaultValue) {
        return ParameterSupport.getLongArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static long[] getLongArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getLongArray(bundle, key, null);
    }

    @Nullable
    public static long[] getLongArray(@Nullable Bundle bundle, @NonNull String key, @Nullable long[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Long> queryValues = ParameterSupport.getQueryLongs(bundle, key);
        long[] value = null;
        if (queryValues != null) {
            value = new long[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getLongArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static float[] getFloatArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getFloatArray(intent, key, null);
    }

    @Nullable
    public static float[] getFloatArray(@NonNull Intent intent, @NonNull String key, @Nullable float[] defaultValue) {
        return ParameterSupport.getFloatArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static float[] getFloatArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getFloatArray(bundle, key, null);
    }

    @Nullable
    public static float[] getFloatArray(@Nullable Bundle bundle, @NonNull String key, @Nullable float[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Float> queryValues = ParameterSupport.getQueryFloats(bundle, key);
        float[] value = null;
        if (queryValues != null) {
            value = new float[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i).floatValue();
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getFloatArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static double[] getDoubleArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getDoubleArray(intent, key, null);
    }

    @Nullable
    public static double[] getDoubleArray(@NonNull Intent intent, @NonNull String key, @Nullable double[] defaultValue) {
        return ParameterSupport.getDoubleArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static double[] getDoubleArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getDoubleArray(bundle, key, null);
    }

    @Nullable
    public static double[] getDoubleArray(@Nullable Bundle bundle, @NonNull String key, @Nullable double[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        List<Double> queryValues = ParameterSupport.getQueryDoubles(bundle, key);
        double[] value = null;
        if (queryValues != null) {
            value = new double[queryValues.size()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = queryValues.get(i);
            }
        }
        if (value == null) {
            value = bundle.containsKey(key) ? bundle.getDoubleArray(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static Parcelable[] getParcelableArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getParcelableArray(intent, key, null);
    }

    @Nullable
    public static Parcelable[] getParcelableArray(@NonNull Intent intent, @NonNull String key, @Nullable Parcelable[] defaultValue) {
        return ParameterSupport.getParcelableArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static Parcelable[] getParcelableArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getParcelableArray(bundle, key, null);
    }

    @Nullable
    public static Parcelable[] getParcelableArray(@Nullable Bundle bundle, @NonNull String key, @Nullable Parcelable[] defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Parcelable[] value = null;
        value = bundle.containsKey(key) ? bundle.getParcelableArray(key) : defaultValue;
        return value;
    }

    @Nullable
    public static <T extends Parcelable> ArrayList<T> getParcelableArrayList(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getParcelableArrayList(intent, key, null);
    }

    @Nullable
    public static <T extends Parcelable> ArrayList<T> getParcelableArrayList(@NonNull Intent intent, @NonNull String key, @Nullable ArrayList<T> defaultValue) {
        return ParameterSupport.getParcelableArrayList(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static <T extends Parcelable> ArrayList<T> getParcelableArrayList(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getParcelableArrayList(bundle, key, null);
    }

    @Nullable
    public static <T extends Parcelable> ArrayList<T> getParcelableArrayList(@Nullable Bundle bundle, @NonNull String key, @Nullable ArrayList<T> defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        ArrayList value = null;
        value = bundle.containsKey(key) ? bundle.getParcelableArrayList(key) : defaultValue;
        return value;
    }

    @Nullable
    public static <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getSparseParcelableArray(intent, key, null);
    }

    @Nullable
    public static <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@NonNull Intent intent, @NonNull String key, @Nullable SparseArray<T> defaultValue) {
        return ParameterSupport.getSparseParcelableArray(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getSparseParcelableArray(bundle, key, null);
    }

    @Nullable
    public static <T extends Parcelable> SparseArray<T> getSparseParcelableArray(@Nullable Bundle bundle, @NonNull String key, @Nullable SparseArray<T> defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        SparseArray value = null;
        value = bundle.containsKey(key) ? bundle.getSparseParcelableArray(key) : defaultValue;
        return value;
    }

    @Nullable
    public static ArrayList<CharSequence> getCharSequenceArrayList(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getCharSequenceArrayList(intent, key, null);
    }

    @Nullable
    public static ArrayList<CharSequence> getCharSequenceArrayList(@NonNull Intent intent, @NonNull String key, @Nullable ArrayList<CharSequence> defaultValue) {
        return ParameterSupport.getCharSequenceArrayList(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static ArrayList<CharSequence> getCharSequenceArrayList(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getCharSequenceArrayList(bundle, key, null);
    }

    @Nullable
    public static ArrayList<CharSequence> getCharSequenceArrayList(@Nullable Bundle bundle, @NonNull String key, @Nullable ArrayList<CharSequence> defaultValue) {
        ArrayList<Object> value;
        if (bundle == null) {
            return defaultValue;
        }
        List<String> queryValues = ParameterSupport.getQueryStrings(bundle, key);
        ArrayList<Object> arrayList = value = queryValues == null ? null : new ArrayList(queryValues);
        if (queryValues == null) {
            value = bundle.containsKey(key) ? bundle.getCharSequenceArrayList(key) : defaultValue;
        }
        return value;
    }

    @Nullable
    public static <T extends Parcelable> T getParcelable(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getParcelable(intent, key, null);
    }

    @Nullable
    public static <T extends Parcelable> T getParcelable(@NonNull Intent intent, @NonNull String key, @Nullable T defaultValue) {
        return ParameterSupport.getParcelable(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static <T extends Parcelable> T getParcelable(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getParcelable(bundle, key, null);
    }

    @Nullable
    public static <T extends Parcelable> T getParcelable(@Nullable Bundle bundle, @NonNull String key, @Nullable T defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Parcelable value = null;
        value = bundle.containsKey(key) ? bundle.getParcelable(key) : (Parcelable)defaultValue;
        return (T)value;
    }

    @Nullable
    public static <T extends Serializable> T getSerializable(@NonNull Intent intent, @NonNull String key) {
        return ParameterSupport.getSerializable(intent, key, null);
    }

    @Nullable
    public static <T extends Serializable> T getSerializable(@NonNull Intent intent, @NonNull String key, @Nullable T defaultValue) {
        return ParameterSupport.getSerializable(intent.getExtras(), key, defaultValue);
    }

    @Nullable
    public static <T extends Serializable> T getSerializable(@Nullable Bundle bundle, @NonNull String key) {
        return ParameterSupport.getSerializable(bundle, key, null);
    }

    @Nullable
    public static <T extends Serializable> T getSerializable(@Nullable Bundle bundle, @NonNull String key, @Nullable T defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        Serializable value = null;
        value = bundle.containsKey(key) ? bundle.getSerializable(key) : (Serializable)defaultValue;
        return (T)value;
    }
}

