/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.interceptor;

import android.net.Uri;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.error.ignore.NavigationFailException;
import com.xiaojinzi.component.impl.RouterInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OpenOnceInterceptor
implements RouterInterceptor {
    private Map<String, Long> map = new HashMap<String, Long>();

    private OpenOnceInterceptor() {
    }

    public static OpenOnceInterceptor getInstance() {
        return SingletonInstance.INSTANCE;
    }

    @Override
    public void intercept(RouterInterceptor.Chain chain) throws Exception {
        Uri uri = chain.request().uri;
        String hostAndPath = new StringBuffer().append(uri.getHost()).append("/").append(uri.getPath()).toString();
        long currentTime = System.currentTimeMillis();
        if (this.map.containsKey(hostAndPath) && currentTime - this.map.get(hostAndPath) < Component.getConfig().getRouteRepeatCheckDuration()) {
            chain.callback().onError(new NavigationFailException("same request can't launch twice in a second, target uri is\uff1a" + uri.toString()));
        } else {
            this.map.put(hostAndPath, currentTime);
            chain.proceed(chain.request());
        }
        this.cleanOverdue();
    }

    private void cleanOverdue() {
        long currentTime = System.currentTimeMillis();
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            if (currentTime - this.map.get(key) < Component.getConfig().getRouteRepeatCheckDuration()) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.map.remove(key);
        }
    }

    private static class SingletonInstance {
        private static final OpenOnceInterceptor INSTANCE = new OpenOnceInterceptor();

        private SingletonInstance() {
        }
    }
}

