/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.interceptor;

import android.app.Application;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.impl.RouterInterceptor;
import com.xiaojinzi.component.impl.interceptor.InterceptorBean;
import com.xiaojinzi.component.interceptor.IComponentHostInterceptor;
import com.xiaojinzi.component.support.RouterInterceptorCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ModuleInterceptorImpl
implements IComponentHostInterceptor {
    protected Map<String, Class<? extends RouterInterceptor>> interceptorMap = new HashMap<String, Class<? extends RouterInterceptor>>();
    private boolean isInitMap = false;

    ModuleInterceptorImpl() {
    }

    @Override
    public void onCreate(@NonNull Application app) {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    @NonNull
    @UiThread
    public List<InterceptorBean> globalInterceptorList() {
        return Collections.emptyList();
    }

    @CallSuper
    @UiThread
    protected void initInterceptorMap() {
        this.isInitMap = true;
    }

    @Override
    @NonNull
    public Set<String> getInterceptorNames() {
        if (!this.isInitMap) {
            this.initInterceptorMap();
        }
        return this.interceptorMap.keySet();
    }

    @Override
    @NonNull
    public Map<String, Class<? extends RouterInterceptor>> getInterceptorMap() {
        if (!this.isInitMap) {
            this.initInterceptorMap();
        }
        return new HashMap<String, Class<? extends RouterInterceptor>>(this.interceptorMap);
    }

    @Override
    @Nullable
    @UiThread
    public RouterInterceptor getByName(@Nullable String name) {
        Class<? extends RouterInterceptor> interceptorClass;
        if (name == null) {
            return null;
        }
        if (!this.isInitMap) {
            this.initInterceptorMap();
        }
        if ((interceptorClass = this.interceptorMap.get(name)) == null) {
            return null;
        }
        return RouterInterceptorCache.getInterceptorByClass(interceptorClass);
    }
}

