/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.fragment;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.fragment.IComponentCenterFragment;
import com.xiaojinzi.component.fragment.IComponentHostFragment;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FragmentCenter
implements IComponentCenterFragment {
    private Map<String, IComponentHostFragment> moduleFragmentMap = new HashMap<String, IComponentHostFragment>();
    private static volatile FragmentCenter instance;

    private FragmentCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FragmentCenter getInstance() {
        if (instance != null) return instance;
        Class<FragmentCenter> clazz = FragmentCenter.class;
        synchronized (FragmentCenter.class) {
            if (instance != null) return instance;
            instance = new FragmentCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(@NonNull IComponentHostFragment hostFragment) {
        Utils.checkNullPointer(hostFragment);
        if (!this.moduleFragmentMap.containsKey(hostFragment.getHost())) {
            this.moduleFragmentMap.put(hostFragment.getHost(), hostFragment);
            hostFragment.onCreate(Component.getApplication());
        }
    }

    @Override
    public void register(@NonNull String host) {
        IComponentHostFragment moduleService;
        Utils.checkStringNullPointer(host, "host");
        if (!this.moduleFragmentMap.containsKey(host) && (moduleService = this.findModuleService(host)) != null) {
            this.register(moduleService);
        }
    }

    @Override
    public void unregister(@NonNull IComponentHostFragment hostFragment) {
        Utils.checkNullPointer(hostFragment);
        this.moduleFragmentMap.remove(hostFragment.getHost());
        hostFragment.onDestroy();
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkStringNullPointer(host, "host");
        IComponentHostFragment moduleService = this.moduleFragmentMap.get(host);
        if (moduleService != null) {
            this.unregister(moduleService);
        }
    }

    @Nullable
    public IComponentHostFragment findModuleService(String host) {
        try {
            if (Component.getConfig().isOptimizeInit()) {
                return ASMUtil.findModuleFragmentAsmImpl(ComponentUtil.transformHostForClass((String)host));
            }
            Class<?> clazz = null;
            String className = ComponentUtil.genHostFragmentClassName((String)host);
            clazz = Class.forName(className);
            return (IComponentHostFragment)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void check() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, IComponentHostFragment> entry : this.moduleFragmentMap.entrySet()) {
            IComponentHostFragment childRouter = entry.getValue();
            if (childRouter == null || childRouter.getFragmentNameSet() == null) continue;
            Set<String> childRouterSet = childRouter.getFragmentNameSet();
            for (String key : childRouterSet) {
                if (set.contains(key)) {
                    throw new IllegalStateException("the name of Fragment is exist\uff1a'" + key + "'");
                }
                set.add(key);
            }
        }
    }
}

