/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.application;

import android.app.Application;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.xiaojinzi.component.application.IApplicationLifecycle;
import com.xiaojinzi.component.application.IComponentHostApplication;
import com.xiaojinzi.component.application.IModuleNotifyChanged;
import java.util.ArrayList;
import java.util.List;

abstract class ModuleApplicationImpl
implements IComponentHostApplication {
    protected List<IApplicationLifecycle> moduleAppList = new ArrayList<IApplicationLifecycle>();
    protected boolean hasInitList = false;

    ModuleApplicationImpl() {
    }

    @CallSuper
    protected void initList() {
        this.hasInitList = true;
    }

    @Override
    @CallSuper
    public void onCreate(@NonNull Application app) {
        if (!this.hasInitList) {
            this.initList();
        }
        if (this.moduleAppList == null) {
            return;
        }
        for (IApplicationLifecycle application : this.moduleAppList) {
            application.onCreate(app);
        }
    }

    @Override
    @CallSuper
    public void onDestroy() {
        if (!this.hasInitList) {
            this.initList();
        }
        if (this.moduleAppList == null) {
            return;
        }
        for (IApplicationLifecycle application : this.moduleAppList) {
            application.onDestroy();
        }
    }

    @Override
    public void onModuleChanged(@NonNull Application app) {
        for (IApplicationLifecycle applicationLifecycle : this.moduleAppList) {
            if (!(applicationLifecycle instanceof IModuleNotifyChanged)) continue;
            ((IModuleNotifyChanged)((Object)applicationLifecycle)).onModuleChanged(app);
        }
    }
}

