/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.bean.PageInterceptorBean;
import com.xiaojinzi.component.bean.RouterBean;
import com.xiaojinzi.component.error.ignore.InterceptorNotFoundException;
import com.xiaojinzi.component.error.ignore.NavigationFailException;
import com.xiaojinzi.component.error.ignore.TargetActivityNotFoundException;
import com.xiaojinzi.component.impl.RouterInterceptor;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.impl.interceptor.InterceptorCenter;
import com.xiaojinzi.component.router.IComponentCenterRouter;
import com.xiaojinzi.component.router.IComponentHostRouter;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.LogUtil;
import com.xiaojinzi.component.support.RouterInterceptorCache;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RouterCenter
implements IComponentCenterRouter {
    private static volatile RouterCenter instance;
    private static Map<String, IComponentHostRouter> hostRouterMap;
    protected final Map<String, RouterBean> routerRegExMap = new HashMap<String, RouterBean>();
    protected final Map<String, RouterBean> routerMap = new HashMap<String, RouterBean>();

    private RouterCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouterCenter getInstance() {
        if (instance != null) return instance;
        Class<RouterCenter> clazz = RouterCenter.class;
        synchronized (RouterCenter.class) {
            if (instance != null) return instance;
            instance = new RouterCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public synchronized boolean isMatchUri(@NonNull Uri uri) {
        return this.getTarget(uri) != null;
    }

    @Override
    public boolean isSameTarget(@NonNull Uri uri1, @NonNull Uri uri2) {
        return this.getTarget(uri1) == this.getTarget(uri2);
    }

    @Override
    @UiThread
    public void openUri(@NonNull RouterRequest routerRequest) throws Exception {
        this.doOpenUri(routerRequest);
    }

    @UiThread
    public void routerDegrade(@NonNull RouterRequest request, @NonNull Intent routerDegradeIntent) throws Exception {
        String uriString = request.uri.toString();
        if (routerDegradeIntent == null) {
            throw new TargetActivityNotFoundException(uriString);
        }
        this.doStartIntent(request, routerDegradeIntent);
    }

    @UiThread
    private void doOpenUri(@NonNull RouterRequest request) throws Exception {
        if (!Utils.isMainThread()) {
            throw new NavigationFailException("Router must run on main thread");
        }
        if (request.uri == null) {
            throw new NavigationFailException("target Uri is null");
        }
        RouterBean target = this.getTarget(request.uri);
        String uriString = request.uri.toString();
        if (target == null) {
            throw new TargetActivityNotFoundException(uriString);
        }
        if (request.context == null && request.fragment == null) {
            throw new NavigationFailException("one of the Context and Fragment must not be null,do you forget call method: \nRouter.with(Context) or Router.with(Fragment)");
        }
        Context rawContext = request.getRawContext();
        if (rawContext == null) {
            throw new NavigationFailException("is your fragment or Activity is Destroyed?\nsee https://github.com/xiaojinzi123/Component/wiki/%E4%B8%BB%E9%A1%B5#%E7%89%B9%E5%88%AB%E6%B3%A8%E6%84%8F");
        }
        Intent intent = null;
        if (target.getTargetClass() != null) {
            intent = new Intent(rawContext, target.getTargetClass());
        } else if (target.getCustomerIntentCall() != null) {
            intent = target.getCustomerIntentCall().get(request);
        }
        if (intent == null) {
            throw new TargetActivityNotFoundException(uriString);
        }
        this.doStartIntent(request, intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    private void doStartIntent(@NonNull RouterRequest request, Intent intent) throws Exception {
        intent.putExtras(request.bundle);
        for (String intentCategory : request.intentCategories) {
            intent.addCategory(intentCategory);
        }
        for (Integer intentFlag : request.intentFlags) {
            intent.addFlags(intentFlag.intValue());
        }
        if (request.intentConsumer != null) {
            request.intentConsumer.accept(intent);
        }
        if (request.context instanceof Application && Component.getConfig().isTipWhenUseApplication()) {
            LogUtil.logw("-------- Router --------", "you use 'Application' to launch Activity. this is not recommended. you should not use 'Application' as far as possible");
        }
        if (request.beforeStartAction != null) {
            request.beforeStartAction.run();
        }
        if (request.isForResult) {
            Fragment rxFragment;
            if (request.context != null) {
                rxFragment = this.findFragment(request.context);
                Activity rawAct = null;
                if (rxFragment != null) {
                    rxFragment.startActivityForResult(intent, request.requestCode.intValue(), request.options);
                } else {
                    rawAct = Utils.getActivityFromContext(request.context);
                    if (rawAct == null) throw new NavigationFailException("Context is not a Activity,so can't use 'startActivityForResult' method");
                    rawAct.startActivityForResult(intent, request.requestCode.intValue(), request.options);
                }
            } else {
                if (request.fragment == null) throw new NavigationFailException("the context or fragment both are null");
                rxFragment = this.findFragment(request.fragment);
                if (rxFragment != null) {
                    rxFragment.startActivityForResult(intent, request.requestCode.intValue(), request.options);
                } else {
                    request.fragment.startActivityForResult(intent, request.requestCode.intValue(), request.options);
                }
            }
        } else if (request.requestCode == null) {
            if (request.context != null) {
                request.context.startActivity(intent, request.options);
            } else {
                if (request.fragment == null) throw new NavigationFailException("the context or fragment both are null");
                request.fragment.startActivity(intent, request.options);
            }
        } else {
            Activity rawAct = null;
            rawAct = Utils.getActivityFromContext(request.context);
            if (rawAct != null) {
                rawAct.startActivityForResult(intent, request.requestCode.intValue(), request.options);
            } else {
                if (request.fragment == null) throw new NavigationFailException("the context or fragment both are null");
                request.fragment.startActivityForResult(intent, request.requestCode.intValue(), request.options);
            }
        }
        if (request.afterStartAction == null) return;
        request.afterStartAction.run();
    }

    @Override
    @NonNull
    public synchronized List<RouterInterceptor> listPageInterceptors(@NonNull Uri uri) {
        RouterBean routerBean = this.getTarget(uri);
        if (routerBean == null) {
            return Collections.emptyList();
        }
        if (routerBean.getPageInterceptors().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RouterInterceptor> result = new ArrayList<RouterInterceptor>(routerBean.getPageInterceptors().size());
        List<PageInterceptorBean> pageInterceptors = routerBean.getPageInterceptors();
        Collections.sort(pageInterceptors, new Comparator<PageInterceptorBean>(){

            @Override
            public int compare(PageInterceptorBean o1, PageInterceptorBean o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (PageInterceptorBean pageInterceptorBean : pageInterceptors) {
            RouterInterceptor interceptor;
            String interceptorName = pageInterceptorBean.getStringInterceptor();
            Class<? extends RouterInterceptor> interceptorClass = pageInterceptorBean.getClassInterceptor();
            if (interceptorName != null && !interceptorName.isEmpty()) {
                interceptor = InterceptorCenter.getInstance().getByName(interceptorName);
                if (interceptor == null) {
                    throw new InterceptorNotFoundException("can't find the interceptor and it's name is " + interceptorName + ",target url is " + uri.toString());
                }
                result.add(interceptor);
                continue;
            }
            if (interceptorClass != null) {
                interceptor = RouterInterceptorCache.getInterceptorByClass(interceptorClass);
                if (interceptor == null) {
                    throw new InterceptorNotFoundException("can't find the interceptor and it's className is " + interceptorClass + ",target url is " + uri.toString());
                }
                result.add(interceptor);
                continue;
            }
            throw new InterceptorNotFoundException("String interceptor and class interceptor are both null");
        }
        return result;
    }

    @Override
    @NonNull
    public synchronized List<RouterInterceptor> listDegradeInterceptors(@NonNull Uri uri) throws Exception {
        return Collections.emptyList();
    }

    @Nullable
    private RouterBean getTarget(@NonNull Uri uri) {
        String targetKey = this.getTargetRouterKey(uri);
        if (targetKey == null) {
            return null;
        }
        for (Map.Entry<String, RouterBean> entry : this.routerRegExMap.entrySet()) {
            if (!Pattern.matches(entry.getKey(), targetKey)) continue;
            return entry.getValue();
        }
        return this.routerMap.get(targetKey);
    }

    @Nullable
    private String getTargetRouterKey(@NonNull Uri uri) {
        String targetPath = uri.getPath();
        if (targetPath != null && targetPath.length() > 0) {
            if (targetPath.charAt(0) != '/') {
                targetPath = "/" + targetPath;
            }
            return uri.getScheme() + "://" + uri.getHost() + targetPath;
        }
        return uri.getScheme() + "://" + uri.getHost();
    }

    @Nullable
    private Fragment findFragment(@NonNull Context context) {
        Fragment result = null;
        Activity act = Utils.getActivityFromContext(context);
        if (act instanceof FragmentActivity) {
            FragmentManager ft = ((FragmentActivity)act).getSupportFragmentManager();
            result = ft.findFragmentByTag("TAG_FOR_ROUTER_GET_ACTIVITY_RESULT");
        }
        return result;
    }

    @Nullable
    private Fragment findFragment(@NonNull Fragment fragment) {
        return fragment.getChildFragmentManager().findFragmentByTag("TAG_FOR_ROUTER_GET_ACTIVITY_RESULT");
    }

    @Override
    public void register(@NonNull IComponentHostRouter router) {
        Utils.checkNullPointer(router);
        if (!hostRouterMap.containsKey(router.getHost())) {
            hostRouterMap.put(router.getHost(), router);
            this.routerRegExMap.putAll(router.getRegExRouterMap());
            this.routerMap.putAll(router.getRouterMap());
        }
    }

    @Override
    public void register(@NonNull String host) {
        IComponentHostRouter router;
        Utils.checkStringNullPointer(host, "host");
        if (!hostRouterMap.containsKey(host) && (router = this.findUiRouter(host)) != null) {
            this.register(router);
        }
    }

    @Override
    public void unregister(@NonNull IComponentHostRouter hostRouter) {
        Utils.checkNullPointer(hostRouter);
        hostRouterMap.remove(hostRouter.getHost());
        Map<String, RouterBean> childRouterMap = hostRouter.getRouterMap();
        if (childRouterMap != null) {
            for (String key : childRouterMap.keySet()) {
                this.routerMap.remove(key);
            }
        }
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkStringNullPointer(host, "host");
        IComponentHostRouter hostRouter = hostRouterMap.get(host);
        if (hostRouter != null) {
            this.unregister(hostRouter);
        }
    }

    @Nullable
    public IComponentHostRouter findUiRouter(String host) {
        try {
            if (Component.getConfig().isOptimizeInit()) {
                return ASMUtil.findModuleRouterAsmImpl(ComponentUtil.transformHostForClass((String)host));
            }
            Class<?> clazz = null;
            String className = ComponentUtil.genHostRouterClassName((String)host);
            clazz = Class.forName(className);
            return (IComponentHostRouter)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void check() {
        HashSet<String> routerSet = new HashSet<String>();
        HashSet routerRegExSet = new HashSet();
        for (Map.Entry<String, IComponentHostRouter> entry : hostRouterMap.entrySet()) {
            IComponentHostRouter childRouter = entry.getValue();
            if (childRouter == null) continue;
            Map<String, RouterBean> childRouterRegexMap = childRouter.getRegExRouterMap();
            for (String key : childRouterRegexMap.keySet()) {
                if (routerRegExSet.contains(key)) {
                    throw new IllegalStateException("the target regex is exist\uff1a" + key);
                }
                routerSet.add(key);
            }
            Map<String, RouterBean> childRouterMap = childRouter.getRouterMap();
            for (String key : childRouterMap.keySet()) {
                if (routerSet.contains(key)) {
                    throw new IllegalStateException("the target uri is exist\uff1a" + key);
                }
                routerSet.add(key);
            }
        }
    }

    static {
        hostRouterMap = new HashMap<String, IComponentHostRouter>();
    }
}

