/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.Fragment;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.cache.ClassCache;
import com.xiaojinzi.component.impl.FragmentNavigator;
import com.xiaojinzi.component.impl.Navigator;
import com.xiaojinzi.component.impl.ProxyIntentBuilder;
import com.xiaojinzi.component.impl.RouterListener;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.support.NavigationDisposable;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Router {
    public static final String TAG = "-------- Router --------";
    public static final NavigationDisposable emptyNavigationDisposable = new NavigationDisposable(){

        @Override
        @Nullable
        public RouterRequest originalRequest() {
            return null;
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean isCanceled() {
            return true;
        }
    };
    static Collection<RouterListener> routerListeners = Collections.synchronizedCollection(new ArrayList(0));
    static List<NavigationDisposable> mNavigationDisposableList = new CopyOnWriteArrayList<NavigationDisposable>();

    protected Router() {
    }

    public static void clearRouterListeners() {
        routerListeners.clear();
    }

    public static void addRouterListener(@NonNull RouterListener listener) {
        if (routerListeners.contains(listener)) {
            return;
        }
        routerListeners.add(listener);
    }

    public static void removeRouterListener(RouterListener listener) {
        if (listener == null) {
            return;
        }
        routerListeners.remove(listener);
    }

    @NonNull
    @AnyThread
    public static ProxyIntentBuilder newProxyIntentBuilder() {
        return new ProxyIntentBuilder();
    }

    @NonNull
    @AnyThread
    public static FragmentNavigator with(@NonNull String fragmentFlag) {
        Utils.checkNullPointer(fragmentFlag, "fragmentFlag");
        return new FragmentNavigator(fragmentFlag);
    }

    @NonNull
    @AnyThread
    public static Navigator with() {
        return new Navigator();
    }

    @NonNull
    @AnyThread
    public static Navigator with(@NonNull Context context) {
        Utils.checkNullPointer(context, "context");
        return new Navigator(context);
    }

    @NonNull
    @AnyThread
    public static Navigator with(@NonNull Fragment fragment) {
        return new Navigator(fragment);
    }

    @NonNull
    @AnyThread
    public static <T> T withApi(@NonNull Class<T> apiClass) {
        Object t = ClassCache.get(apiClass);
        if (t == null) {
            String className = ComponentUtil.genRouterApiImplClassName(apiClass);
            try {
                t = Class.forName(className).newInstance();
                ClassCache.put(apiClass, t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return t;
    }

    public static boolean isProxyIntentExist(@Nullable Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return bundle.getBoolean("router_proxy_intent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public static void cancel(@NonNull Activity act) {
        Utils.checkMainThread();
        List<NavigationDisposable> list = mNavigationDisposableList;
        synchronized (list) {
            for (int i = mNavigationDisposableList.size() - 1; i >= 0; --i) {
                NavigationDisposable disposable = mNavigationDisposableList.get(i);
                if (act != Utils.getActivityFromContext(disposable.originalRequest().context)) continue;
                disposable.cancel();
                mNavigationDisposableList.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public static void cancel(@NonNull Fragment fragment) {
        Utils.checkMainThread();
        List<NavigationDisposable> list = mNavigationDisposableList;
        synchronized (list) {
            for (int i = mNavigationDisposableList.size() - 1; i >= 0; --i) {
                NavigationDisposable disposable = mNavigationDisposableList.get(i);
                if (fragment != disposable.originalRequest().fragment) continue;
                disposable.cancel();
                mNavigationDisposableList.remove(i);
            }
        }
    }
}

