/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.cache;

import android.app.ActivityManager;
import android.content.Context;
import android.support.annotation.NonNull;
import com.xiaojinzi.component.support.Utils;

public interface CacheType {
    public static final int CLASS_CACHE_TYPE_ID = 0;
    public static final CacheType CLASS_CACHE = new CacheType(){
        private static final int MAX_SIZE = 25;

        @Override
        public int getCacheTypeId() {
            return 0;
        }

        @Override
        public int calculateCacheSize(Context context) {
            Utils.checkNullPointer(context, "context");
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int targetMemoryCacheSize = Utils.isLowMemoryDevice(activityManager) ? activityManager.getMemoryClass() / 6 : activityManager.getMemoryClass() / 4;
            if (targetMemoryCacheSize > 25) {
                return 25;
            }
            return targetMemoryCacheSize;
        }
    };

    public int getCacheTypeId();

    public int calculateCacheSize(@NonNull Context var1);
}

