/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.xiaojinzi.component.ComponentActivityStack;
import com.xiaojinzi.component.impl.Router;

class ComponentLifecycleCallback
implements Application.ActivityLifecycleCallbacks {
    private final FragmentManager.FragmentLifecycleCallbacks fragmentLifecycleCallbacks = new FragmentManager.FragmentLifecycleCallbacks(){

        public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
            super.onFragmentDestroyed(fm, f);
            Router.cancel(f);
        }
    };

    ComponentLifecycleCallback() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        ComponentActivityStack.getInstance().pushActivity(activity);
        if (activity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)activity;
            fragmentActivity.getSupportFragmentManager().registerFragmentLifecycleCallbacks(this.fragmentLifecycleCallbacks, true);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        ComponentActivityStack.getInstance().removeActivity(activity);
        Router.cancel(activity);
    }
}

