/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.ComponentLifecycleCallback;
import com.xiaojinzi.component.Config;
import com.xiaojinzi.component.impl.RouterCenter;
import com.xiaojinzi.component.impl.application.ModuleManager;
import com.xiaojinzi.component.impl.fragment.FragmentCenter;
import com.xiaojinzi.component.impl.interceptor.InterceptorCenter;
import com.xiaojinzi.component.support.Inject;
import com.xiaojinzi.component.support.LogUtil;
import com.xiaojinzi.component.support.Utils;

public class Component {
    public static final String GITHUB_URL = "https://github.com/xiaojinzi123/Component";
    public static final String DOC_URL = "https://github.com/xiaojinzi123/Component/wiki";
    public static final String COMMON_ERROR_ISSUE = "https://github.com/xiaojinzi123/Component/issues/21";
    public static final String ROUTER_UES_NOTE = "https://github.com/xiaojinzi123/Component/wiki/%E4%B8%BB%E9%A1%B5#%E7%89%B9%E5%88%AB%E6%B3%A8%E6%84%8F";
    private static boolean isInit = false;
    private static boolean isDebug = false;
    private static Config mConfig = null;

    private Component() {
    }

    @UiThread
    public static void init(boolean isDebug, @NonNull Config config) {
        if (isInit) {
            throw new RuntimeException("you have init Component already!");
        }
        Utils.checkMainThread();
        Utils.checkNullPointer(config, "config");
        Component.isDebug = isDebug;
        mConfig = config;
        if (isDebug) {
            Component.printComponent();
        }
        mConfig.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ComponentLifecycleCallback());
        if (mConfig.isOptimizeInit() && mConfig.isAutoRegisterModule()) {
            ModuleManager.getInstance().autoRegister();
        }
        isInit = true;
    }

    private static void printComponent() {
        StringBuffer sb = new StringBuffer();
        sb.append(" \n");
        sb.append("\n");
        sb.append("             *********\n");
        sb.append("          ****        ****\n");
        sb.append("       ****              ****\n");
        sb.append("     ****\n");
        sb.append("    ****\n");
        sb.append("    ****\n");
        sb.append("    ****\n");
        sb.append("     ****\n");
        sb.append("       ****              ****\n");
        sb.append("          ****        ****\n");
        sb.append("             *********\n");
        sb.append("\u611f\u8c22\u60a8\u9009\u62e9 Component \u7ec4\u4ef6\u5316\u6846\u67b6. \n\u6709\u4efb\u4f55\u95ee\u9898\u6b22\u8fce\u63d0 issue \u6216\u8005\u626b\u63cf github \u4e0a\u7684\u4e8c\u7ef4\u7801\u8fdb\u5165\u7fa4\u804a@\u7fa4\u4e3b\n").append("Github \u5730\u5740\uff1ahttps://github.com/xiaojinzi123/Component").append("\n\u6587\u6863\u5730\u5740\uff1ahttps://github.com/xiaojinzi123/Component/wiki").append("\n\u9519\u8bef\u6392\u67e5\u6307\u5357\uff1ahttps://github.com/xiaojinzi123/Component/issues/21").append("\n ");
        LogUtil.logw(sb.toString());
    }

    @NonNull
    @AnyThread
    public static Config getConfig() {
        Component.checkInit();
        return mConfig;
    }

    @AnyThread
    public static boolean isDebug() {
        return isDebug;
    }

    @NonNull
    @AnyThread
    public static Application getApplication() {
        Component.checkInit();
        return mConfig.getApplication();
    }

    private static void checkInit() {
        if (mConfig == null) {
            throw new RuntimeException("you must init Component first!");
        }
    }

    @UiThread
    public static void inject(@NonNull Object target) {
        Component.inject(target, null, true, true);
    }

    @UiThread
    public static void injectAttrValueFromIntent(@NonNull Object target, @Nullable Intent intent) {
        Component.injectAttrValueFromBundle(target, intent == null ? null : intent.getExtras());
    }

    @UiThread
    public static void injectAttrValueFromBundle(@NonNull Object target, @Nullable Bundle bundle) {
        Component.inject(target, bundle, true, false);
    }

    @UiThread
    public static void injectService(@NonNull Object target) {
        Component.inject(target, null, false, true);
    }

    @UiThread
    private static void inject(@NonNull Object target, @Nullable Bundle bundle, boolean isAutoWireAttrValue, boolean isAutoWireService) {
        Utils.checkMainThread();
        Utils.checkNullPointer(target, "target");
        String injectClassName = target.getClass().getName() + "_inject";
        try {
            Class<?> targetInjectClass = Class.forName(injectClassName);
            Inject inject = (Inject)targetInjectClass.newInstance();
            if (isAutoWireService) {
                inject.injectService(target);
            }
            if (isAutoWireAttrValue) {
                if (bundle == null) {
                    inject.injectAttrValue(target);
                } else {
                    Utils.checkNullPointer(bundle, "bundle");
                    inject.injectAttrValue(target, bundle);
                }
            }
        }
        catch (Exception ignore) {
            LogUtil.log("class '" + target.getClass().getName() + "' inject fail");
        }
    }

    public static void check() {
        if (Component.isDebug() && Component.getConfig().isErrorCheck()) {
            RouterCenter.getInstance().check();
            InterceptorCenter.getInstance().check();
            FragmentCenter.getInstance().check();
        }
    }
}

