/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.anno.RouterDegradeAnno;
import com.xiaojinzi.component.bean.RouterDegradeAnnoBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.RouterDegradeAnno"})
@AutoService(value={Processor.class})
public class RouterDegradeProcessor
extends BaseHostProcessor {
    private TypeMirror typeRouterDegradeTypeMirror;
    private TypeElement routerDegradeBeanTypeElement;
    private TypeElement routerInterceptorTypeElement;
    final AtomicInteger atomicInteger = new AtomicInteger();
    private List<RouterDegradeAnnoBean> routerDegradeAnnoBeanList = new ArrayList<RouterDegradeAnnoBean>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.typeRouterDegradeTypeMirror = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterDegrade").asType();
        this.routerDegradeBeanTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.bean.RouterDegradeBean");
        this.routerInterceptorTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterInterceptor");
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> routerDegradeElements = roundEnvironment.getElementsAnnotatedWith(RouterDegradeAnno.class);
            this.parseRouterDegradeAnnotation(routerDegradeElements);
            this.createImpl();
            return true;
        }
        return false;
    }

    private void parseRouterDegradeAnnotation(Set<? extends Element> routerDegradeElements) {
        this.routerDegradeAnnoBeanList.clear();
        if (routerDegradeElements == null || routerDegradeElements.size() == 0) {
            return;
        }
        for (Element element : routerDegradeElements) {
            boolean subType;
            RouterDegradeAnno anno = element.getAnnotation(RouterDegradeAnno.class);
            if (anno == null) continue;
            TypeMirror tm = element.asType();
            boolean type = !(element instanceof TypeElement);
            boolean bl = subType = !this.mTypes.isSubtype(tm, this.typeRouterDegradeTypeMirror);
            if (type || subType) continue;
            RouterDegradeAnnoBean targetBean = new RouterDegradeAnnoBean();
            targetBean.setRawType(element);
            targetBean.setPriority(anno.priority());
            this.routerDegradeAnnoBeanList.add(targetBean);
        }
    }

    private void createImpl() {
        String claName = ComponentUtil.genHostRouterDegradeClassName((String)this.componentModuleName);
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.ModuleRouterDegradeImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec initListMethod = this.generateInitListMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addJavadoc(this.componentModuleName + "\u8def\u7531\u964d\u7ea7\u7684\u6a21\u5757\n", new Object[0]).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(initListMethod).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private MethodSpec generateInitHostMethod() {
        ClassName returnType = this.mClassNameString;
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns((TypeName)returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    private MethodSpec generateInitListMethod() {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"initList").returns(TypeName.VOID).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (RouterDegradeAnnoBean item : this.routerDegradeAnnoBeanList) {
            String className = item.getRawType().toString();
            methodSpecBuilder.addComment("--------------------------" + className + "--------------------------", new Object[0]);
            String routerBeanName = "routerDegradeBean" + this.atomicInteger.incrementAndGet();
            methodSpecBuilder.addStatement("$T " + routerBeanName + " = new $T()", new Object[]{this.routerDegradeBeanTypeElement, this.routerDegradeBeanTypeElement});
            methodSpecBuilder.addStatement(routerBeanName + ".setPriority($L)", new Object[]{item.getPriority()});
            methodSpecBuilder.addStatement(routerBeanName + ".setTargetClass($N.class)", new Object[]{className});
            methodSpecBuilder.addStatement("routerDegradeBeanList.add($N)", new Object[]{routerBeanName});
        }
        return methodSpecBuilder.build();
    }
}

