/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

public class ComponentUtil {
    public static final String IMPL_OUTPUT_PKG = "com.xiaojinzi.component.impl";
    public static final String DOT = ".";
    public static final String UIROUTER = "RouterGenerated";
    public static final String UIROUTER_DEGRADE = "RouterDegradeGenerated";
    public static final String UIROUTERAPI = "RouterApiGenerated";
    public static final String MODULE_APPLCATION = "ModuleAppGenerated";
    public static final String MODULE_APPLCATION_DEFAULT = "ModuleAppGeneratedDefault";
    public static final String SERVICE = "ServiceGenerated";
    public static final String INTERCEPTOR = "InterceptorGenerated";
    public static final String Fragment = "FragmentGenerated";
    public static final String GLOBAL_INTERCEPTOR_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.GlobalInterceptorAnno";
    public static final String INTERCEPTOR_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.InterceptorAnno";
    public static final String ROUTER_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.RouterAnno";
    public static final String FRAGMENTANNO_CLASS_NAME = "com.xiaojinzi.component.anno.FragmentAnno";
    public static final String ROUTER_DEGRADE_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.RouterDegradeAnno";
    public static final String MODULE_APP_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.ModuleAppAnno";
    public static final String SERVICE_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.ServiceAnno";
    public static final String SERVICE_DECORATOR_ANNO_CLASS_NAME = "com.xiaojinzi.component.anno.ServiceDecoratorAnno";
    public static final String PARAMETERANNO_CLASS_NAME = "com.xiaojinzi.component.anno.ParameterAnno";
    public static final String ATTR_VALUE_AUTOWIREDANNO_CLASS_NAME = "com.xiaojinzi.component.anno.AttrValueAutowiredAnno";
    public static final String SERVICEAUTOWIREDANNO_CLASS_NAME = "com.xiaojinzi.component.anno.ServiceAutowiredAnno";
    public static final String URIAUTOWIREDANNO_CLASS_NAME = "com.xiaojinzi.component.anno.UriAutowiredAnno";
    public static final String ROUTERAPIANNO_CLASS_NAME = "com.xiaojinzi.component.anno.router.RouterApiAnno";
    public static final String UIROUTER_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.ModuleRouterImpl";
    public static final String UIROUTER_DEGRADE_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.ModuleRouterDegradeImpl";
    public static final String MODULE_APPLICATION_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.application.ModuleApplicationImpl";
    public static final String SERVICE_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.service.ModuleServiceImpl";
    public static final String INTERCEPTOR_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.interceptor.ModuleInterceptorImpl";
    public static final String FRAGMENT_IMPL_CLASS_NAME = "com.xiaojinzi.component.impl.fragment.ModuleFragmentImpl";

    private ComponentUtil() {
    }

    public static char charUpperCase(char target) {
        if (target >= 'a' && target <= 'z') {
            target = (char)(target - 32);
        }
        return target;
    }

    public static String transformHostForClass(String host) {
        StringBuffer sb = new StringBuffer();
        char[] hostChars = host.toCharArray();
        for (int i = 0; i < hostChars.length; ++i) {
            char itemChar = hostChars[i];
            boolean isLetter = itemChar >= 'a' && itemChar <= 'z' || itemChar >= 'A' && itemChar <= 'Z';
            boolean isNumber = itemChar >= '0' && itemChar <= '9';
            boolean isTransform = false;
            boolean needUpperCase = false;
            if (i == 0) {
                if (isLetter) {
                    needUpperCase = true;
                } else {
                    isTransform = true;
                }
            } else if (!isLetter && !isNumber) {
                isTransform = true;
            }
            if (isTransform) {
                sb.append("_");
                continue;
            }
            if (needUpperCase) {
                sb.append(ComponentUtil.charUpperCase(itemChar));
                continue;
            }
            sb.append(itemChar);
        }
        return sb.toString();
    }

    public static String genRouterApiImplClassName(Class apiClass) {
        return apiClass.getName() + UIROUTERAPI;
    }

    public static String genHostModuleApplicationClassName(String host) {
        return "com.xiaojinzi.component.impl.application." + ComponentUtil.transformHostForClass(host) + MODULE_APPLCATION;
    }

    public static String genDefaultHostModuleApplicationClassName(String host) {
        return "com.xiaojinzi.component.impl.application." + ComponentUtil.transformHostForClass(host) + MODULE_APPLCATION_DEFAULT;
    }

    public static String genHostRouterClassName(String host) {
        return "com.xiaojinzi.component.impl." + ComponentUtil.transformHostForClass(host) + UIROUTER;
    }

    public static String genHostRouterDegradeClassName(String host) {
        return "com.xiaojinzi.component.impl." + ComponentUtil.transformHostForClass(host) + UIROUTER_DEGRADE;
    }

    public static String genHostServiceClassName(String host) {
        return "com.xiaojinzi.component.impl.service." + ComponentUtil.transformHostForClass(host) + SERVICE;
    }

    public static String genHostInterceptorClassName(String host) {
        return "com.xiaojinzi.component.impl.interceptor." + ComponentUtil.transformHostForClass(host) + INTERCEPTOR;
    }

    public static String genHostFragmentClassName(String host) {
        return "com.xiaojinzi.component.impl.fragment." + ComponentUtil.transformHostForClass(host) + Fragment;
    }

    public static String getGetSetMethodName(String name, boolean isGet, boolean isBoolean) {
        StringBuffer sb = new StringBuffer();
        char firstChar = ComponentUtil.charUpperCase(name.charAt(0));
        if (isBoolean && name.startsWith("is")) {
            if (isGet) {
                sb.append("is");
            } else {
                sb.append("set");
            }
            sb.append(name.substring(2));
        } else {
            if (isGet) {
                sb.append("get");
            } else {
                sb.append("set");
            }
            sb.append(firstChar);
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
        }
        return sb.toString();
    }
}

