/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.androidx.transformers;

import android.view.View;
import androidx.core.view.ViewCompat;
import com.stx.xhb.androidx.transformers.BasePageTransformer;

public class OverLapPageTransformer
extends BasePageTransformer {
    private float scaleValue = 0.8f;
    private float alphaValue = 1.0f;

    public OverLapPageTransformer() {
    }

    public OverLapPageTransformer(float scaleValue, float alphaValue) {
        this.scaleValue = scaleValue;
        this.alphaValue = alphaValue;
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        view.setAlpha(1.0f);
        view.setScaleY(this.scaleValue);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        view.setAlpha(1.0f + position * (1.0f - this.alphaValue));
        ViewCompat.setTranslationZ((View)view, (float)position);
        float scale = Math.max(this.scaleValue, 1.0f - Math.abs(position));
        view.setScaleY(scale);
    }

    @Override
    public void handleRightPage(View view, float position) {
        view.setAlpha(1.0f - position * (1.0f - this.alphaValue));
        ViewCompat.setTranslationZ((View)view, (float)(-position));
        float scale = Math.max(this.scaleValue, 1.0f - Math.abs(position));
        view.setScaleY(scale);
    }
}

