/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class RotatePageTransformer
extends BasePageTransformer {
    private float mMaxRotation = 15.0f;

    public RotatePageTransformer() {
    }

    public RotatePageTransformer(float maxRotation) {
        this.setMaxRotation(maxRotation);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        view.setPivotX((float)view.getMeasuredWidth() * 0.5f);
        view.setPivotY((float)view.getMeasuredHeight());
        view.setRotation(0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        float rotation = this.mMaxRotation * position;
        view.setPivotX((float)view.getMeasuredWidth() * 0.5f);
        view.setPivotY((float)view.getMeasuredHeight());
        view.setRotation(rotation);
    }

    @Override
    public void handleRightPage(View view, float position) {
        this.handleLeftPage(view, position);
    }

    public void setMaxRotation(float maxRotation) {
        if (maxRotation >= 0.0f && maxRotation <= 40.0f) {
            this.mMaxRotation = maxRotation;
        }
    }
}

