/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewCompat;
import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class AlphaPageTransformer
extends BasePageTransformer {
    private float mMinScale = 0.4f;

    public AlphaPageTransformer() {
    }

    public AlphaPageTransformer(float minScale) {
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(this.mMinScale + (1.0f - this.mMinScale) * (1.0f + position)));
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(this.mMinScale + (1.0f - this.mMinScale) * (1.0f - position)));
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.0f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

