/*
 * Decompiled with CFR 0.152.
 */
package com.github.wvengen.maven.proguard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.artifact.Artifact;

public class ArtifactFilter {
    private static final String WILDCARD = "*";
    protected String groupId;
    protected String artifactId;
    protected String classifier;

    public boolean match(Artifact artifact) {
        boolean artifactMatch = WILDCARD.equals(this.artifactId) || artifact.getArtifactId().equals(this.artifactId) || this.artifactId != null && this.getMatcher(artifact).matches();
        boolean groupMatch = artifact.getGroupId().equals(this.groupId);
        boolean classifierMatch = this.classifier == null && artifact.getClassifier() == null || this.classifier != null && this.classifier.equals(artifact.getClassifier());
        return artifactMatch && groupMatch && classifierMatch;
    }

    private Matcher getMatcher(Artifact artifact) {
        try {
            Pattern compile = Pattern.compile(this.artifactId);
            return compile.matcher(artifact.getArtifactId());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex artifact filter: " + this, e);
        }
    }

    public String toString() {
        return "groupId:" + this.groupId + ", artifactId:" + this.artifactId + ", classifier:" + this.classifier;
    }
}

