/*
 * Decompiled with CFR 0.152.
 */
package com.github.wujun234.uid.impl;

import com.github.wujun234.uid.buffer.BufferPaddingExecutor;
import com.github.wujun234.uid.buffer.RejectedPutBufferHandler;
import com.github.wujun234.uid.buffer.RejectedTakeBufferHandler;
import com.github.wujun234.uid.buffer.RingBuffer;
import com.github.wujun234.uid.exception.UidGenerateException;
import com.github.wujun234.uid.impl.DefaultUidGenerator;
import com.github.wujun234.uid.impl.UidProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="uid.cached-uid-generator")
public class CachedUidGenerator
extends DefaultUidGenerator
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedUidGenerator.class);
    private static final int DEFAULT_BOOST_POWER = 3;
    private int boostPower = 3;
    private int paddingFactor = 50;
    private Long scheduleInterval;
    @Autowired(required=false)
    private RejectedPutBufferHandler rejectedPutBufferHandler;
    @Autowired(required=false)
    private RejectedTakeBufferHandler rejectedTakeBufferHandler;
    private RingBuffer ringBuffer;
    private BufferPaddingExecutor bufferPaddingExecutor;

    public CachedUidGenerator(UidProperties uidProperties) {
        super(uidProperties);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.initRingBuffer();
        LOGGER.info("Initialized RingBuffer successfully.");
    }

    @Override
    public long getUID() {
        try {
            return this.ringBuffer.take();
        }
        catch (Exception e) {
            LOGGER.error("Generate unique id exception. ", (Throwable)e);
            throw new UidGenerateException(e);
        }
    }

    @Override
    public String parseUID(long uid) {
        return super.parseUID(uid);
    }

    public void destroy() throws Exception {
        this.bufferPaddingExecutor.shutdown();
    }

    protected List<Long> nextIdsForOneSecond(long currentSecond) {
        int listSize = (int)this.bitsAllocator.getMaxSequence() + 1;
        ArrayList<Long> uidList = new ArrayList<Long>(listSize);
        long firstSeqUid = this.bitsAllocator.allocate(currentSecond - this.uidProperties.getEpochSeconds(), this.workerId, 0L);
        for (int offset = 0; offset < listSize; ++offset) {
            uidList.add(firstSeqUid + (long)offset);
        }
        return uidList;
    }

    private void initRingBuffer() {
        int bufferSize = (int)this.bitsAllocator.getMaxSequence() + 1 << this.boostPower;
        this.ringBuffer = new RingBuffer(bufferSize, this.paddingFactor);
        LOGGER.info("Initialized ring buffer size:{}, paddingFactor:{}", (Object)bufferSize, (Object)this.paddingFactor);
        boolean usingSchedule = this.scheduleInterval != null;
        this.bufferPaddingExecutor = new BufferPaddingExecutor(this.ringBuffer, this::nextIdsForOneSecond, usingSchedule);
        if (usingSchedule) {
            this.bufferPaddingExecutor.setScheduleInterval(this.scheduleInterval);
        }
        LOGGER.info("Initialized BufferPaddingExecutor. Using schdule:{}, interval:{}", (Object)usingSchedule, (Object)this.scheduleInterval);
        this.ringBuffer.setBufferPaddingExecutor(this.bufferPaddingExecutor);
        if (this.rejectedPutBufferHandler != null) {
            this.ringBuffer.setRejectedPutHandler(this.rejectedPutBufferHandler);
        }
        if (this.rejectedTakeBufferHandler != null) {
            this.ringBuffer.setRejectedTakeHandler(this.rejectedTakeBufferHandler);
        }
        this.bufferPaddingExecutor.paddingBuffer();
        this.bufferPaddingExecutor.start();
    }

    public void setBoostPower(int boostPower) {
        Assert.isTrue((boostPower > 0 ? 1 : 0) != 0, (String)"Boost power must be positive!");
        this.boostPower = boostPower;
    }

    public void setPaddingFactor(int paddingFactor) {
        Assert.isTrue((paddingFactor > 0 && paddingFactor < 100 ? 1 : 0) != 0, (String)"padding factor must be in (0, 100)!");
        this.paddingFactor = paddingFactor;
    }

    public void setRejectedPutBufferHandler(RejectedPutBufferHandler rejectedPutBufferHandler) {
        Assert.notNull((Object)rejectedPutBufferHandler, (String)"RejectedPutBufferHandler can't be null!");
        this.rejectedPutBufferHandler = rejectedPutBufferHandler;
    }

    public void setRejectedTakeBufferHandler(RejectedTakeBufferHandler rejectedTakeBufferHandler) {
        Assert.notNull((Object)rejectedTakeBufferHandler, (String)"RejectedTakeBufferHandler can't be null!");
        this.rejectedTakeBufferHandler = rejectedTakeBufferHandler;
    }

    public void setScheduleInterval(long scheduleInterval) {
        Assert.isTrue((scheduleInterval > 0L ? 1 : 0) != 0, (String)"Schedule interval must positive!");
        this.scheduleInterval = scheduleInterval;
    }
}

