/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.impl;

import com.github.wtekiela.opensub4j.impl.ListOperation;
import com.github.wtekiela.opensub4j.response.SubtitleInfo;
import java.util.HashMap;

class SearchOperation
extends ListOperation<SubtitleInfo> {
    private final String loginToken;
    private final String lang;
    private final String movieHash;
    private final String movieByteSize;
    private final String tag;
    private final String imdbid;
    private final String query;
    private final String season;
    private final String episode;

    public SearchOperation(String loginToken, String lang, String movieHash, String movieByteSize, String tag, String imdbid, String query, String season, String episode) {
        this.loginToken = loginToken;
        this.lang = lang;
        this.movieHash = movieHash;
        this.movieByteSize = movieByteSize;
        this.tag = tag;
        this.imdbid = imdbid;
        this.query = query;
        this.season = season;
        this.episode = episode;
    }

    @Override
    String getMethodName() {
        return "SearchSubtitles";
    }

    @Override
    Object[] getParams() {
        HashMap<String, String> videoProperties = new HashMap<String, String>();
        videoProperties.put("sublanguageid", this.lang);
        if (this.movieHash != null && !this.movieHash.isEmpty() && this.movieByteSize != null && !this.movieByteSize.isEmpty()) {
            videoProperties.put("moviehash", this.movieHash);
            videoProperties.put("moviebytesize", this.movieByteSize);
        } else if (this.tag != null && !this.imdbid.isEmpty()) {
            videoProperties.put("tag", this.tag);
        } else if (this.imdbid != null && !this.imdbid.isEmpty()) {
            videoProperties.put("imdbid", this.imdbid);
        } else if (this.query != null && !this.query.isEmpty()) {
            videoProperties.put("query", this.query);
            if (this.season != null && !this.season.isEmpty()) {
                videoProperties.put("season", this.season);
            }
            if (this.episode != null && !this.episode.isEmpty()) {
                videoProperties.put("episode", this.episode);
            }
        }
        Object[] videoParams = new Object[]{videoProperties};
        Object[] params = new Object[]{this.loginToken, videoParams};
        return params;
    }

    @Override
    Class<SubtitleInfo> getResponseClass() {
        return SubtitleInfo.class;
    }
}

