/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.impl;

import com.github.wtekiela.opensub4j.response.OpenSubtitlesApiSpec;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ResponseParser {
    public static final String LIST_DATA_KEY = "data";

    ResponseParser() {
    }

    public <T> List<T> bindList(Class<T> clazz, Map<String, Object> response) throws InstantiationException, IllegalAccessException {
        Object dataValue = response.get(LIST_DATA_KEY);
        if (!(dataValue instanceof Object[])) {
            return new ArrayList(0);
        }
        Object[] rawData = (Object[])dataValue;
        ArrayList<T> list = new ArrayList<T>(rawData.length);
        for (Object obj : rawData) {
            list.add(this.bind(clazz.newInstance(), (Map)obj));
        }
        return list;
    }

    public <T> T bind(T instance, Map response) {
        if (instance == null) {
            return null;
        }
        Set<Field> declaredFields = ResponseParser.getAllClassFields(instance.getClass());
        for (Field field : declaredFields) {
            this.bindField(instance, response, field);
        }
        return instance;
    }

    private static Set<Field> getAllClassFields(Class type) {
        HashSet<Field> fields = new HashSet<Field>();
        Class currentType = type;
        do {
            fields.addAll(Arrays.asList(currentType.getDeclaredFields()));
        } while ((currentType = currentType.getSuperclass()) != null);
        return fields;
    }

    private <T> void bindField(T instance, Map response, Field field) {
        this.ensureFieldIsAccessible(field);
        OpenSubtitlesApiSpec annotation = field.getAnnotation(OpenSubtitlesApiSpec.class);
        if (annotation != null) {
            this.executeFieldBinding(instance, response, field, annotation);
        }
    }

    private <T> void executeFieldBinding(T instance, Map response, Field field, OpenSubtitlesApiSpec annotation) {
        Object value = response.get(annotation.fieldName());
        if (value == null) {
            return;
        }
        Class<?> source = value.getClass();
        Class<?> target = field.getType();
        if (this.needsStringConversion(target, source)) {
            value = this.parse(target, (String)value);
        }
        try {
            this.set(target, value, instance, field);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private boolean needsStringConversion(Class<?> target, Class<?> source) {
        return target != String.class && source == String.class;
    }

    private void ensureFieldIsAccessible(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    private Object parse(Class target, String value) {
        if (Boolean.class == target || Boolean.TYPE == target) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == target || Byte.TYPE == target) {
            return Byte.parseByte(value);
        }
        if (Character.class == target || Character.TYPE == target) {
            return Character.valueOf(value.charAt(0));
        }
        if (Short.class == target || Short.TYPE == target) {
            return Short.parseShort(value);
        }
        if (Integer.class == target || Integer.TYPE == target) {
            return Integer.parseInt(value);
        }
        if (Long.class == target || Long.TYPE == target) {
            return Long.parseLong(value);
        }
        if (Float.class == target || Float.TYPE == target) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == target || Double.TYPE == target) {
            return Double.parseDouble(value);
        }
        return this.customObjectFromString(target, value);
    }

    private Object customObjectFromString(Class target, String value) {
        try {
            return target.getConstructor(String.class).newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return value;
        }
    }

    private void set(Class target, Object value, Object instance, Field field) throws IllegalAccessException {
        if (Boolean.TYPE == target) {
            field.setBoolean(instance, (Boolean)value);
        } else if (Byte.TYPE == target) {
            field.setByte(instance, (Byte)value);
        } else if (Character.TYPE == target) {
            field.setChar(instance, ((Character)value).charValue());
        } else if (Short.TYPE == target) {
            field.setShort(instance, (Short)value);
        } else if (Integer.TYPE == target) {
            field.setInt(instance, (Integer)value);
        } else if (Long.TYPE == target) {
            field.setLong(instance, (Long)value);
        } else if (Float.TYPE == target) {
            field.setFloat(instance, ((Float)value).floatValue());
        } else if (Double.TYPE == target) {
            field.setDouble(instance, (Double)value);
        } else {
            field.set(instance, value);
        }
    }
}

