/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.impl;

import com.github.wtekiela.opensub4j.api.FileHashCalculator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;

public class OpenSubtitlesFileHashCalculator
implements FileHashCalculator {
    private static final int HASH_CHUNK_SIZE = 65536;

    @Override
    public String calculateHash(File file) throws IOException {
        try (FileChannel fileChannel = new FileInputStream(file).getChannel();){
            long size = file.length();
            long chunkSize = Math.min(65536L, size);
            long startOffset = 0L;
            long endOffset = Math.max(size - 65536L, 0L);
            long head = this.computeHashForChunk(fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, chunkSize));
            long tail = this.computeHashForChunk(fileChannel.map(FileChannel.MapMode.READ_ONLY, endOffset, chunkSize));
            String string = String.format("%016x", size + head + tail);
            return string;
        }
    }

    private long computeHashForChunk(ByteBuffer buffer) {
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

