/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.modularadapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.github.wrdlbrnft.modularadapter.ModularAdapter;
import com.github.wrdlbrnft.modularadapter.itemmanager.ItemManager;
import java.util.List;

class ModularAdapterImpl<T>
extends ModularAdapter<T> {
    private final List<Module<?, ?>> mModules;

    ModularAdapterImpl(Context context, ItemManager<T> itemManager, List<Module<?, ?>> modules) {
        super(context, itemManager);
        this.mModules = modules;
    }

    @Override
    @NonNull
    protected ModularAdapter.ViewHolder<? extends T> onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, int viewType) {
        for (Module<?, ?> module : this.mModules) {
            if (((Module)module).mViewType != viewType) continue;
            return ((Module)module).mHolderFactory.create(inflater, parent);
        }
        throw new IllegalStateException("No mapping for " + viewType + " exists.");
    }

    @Override
    public int getViewTypeOf(Class<? extends T> model) {
        for (Module<?, ?> module : this.mModules) {
            if (!((Module)module).mItemClass.isAssignableFrom(model)) continue;
            return ((Module)module).mViewType;
        }
        throw new IllegalStateException("No mapping for " + model + " exists.");
    }

    public int getItemViewType(int position) {
        Object item = this.getItem(position);
        Class<?> itemClass = item.getClass();
        return this.getViewTypeOf(itemClass);
    }

    static class Module<M, VH extends ModularAdapter.ViewHolder<M>> {
        private final int mViewType;
        private final Class<M> mItemClass;
        private final ModularAdapter.ViewHolderFactory<VH> mHolderFactory;

        Module(int viewType, Class<M> itemClass, ModularAdapter.ViewHolderFactory<VH> holderFactory) {
            this.mViewType = viewType;
            this.mItemClass = itemClass;
            this.mHolderFactory = holderFactory;
        }
    }
}

