/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.modularadapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.wrdlbrnft.modularadapter.ModularAdapterImpl;
import com.github.wrdlbrnft.modularadapter.itemmanager.ChangeSet;
import com.github.wrdlbrnft.modularadapter.itemmanager.ItemManager;
import java.util.ArrayList;
import java.util.List;

public abstract class ModularAdapter<T>
extends RecyclerView.Adapter<ViewHolder<? extends T>> {
    private final ItemManager<T> mItemManager;
    private final LayoutInflater mInflater;

    public ModularAdapter(@NonNull Context context, @NonNull ItemManager<T> itemManager) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mItemManager = itemManager;
        itemManager.addChangeSetCallback(changeSet -> changeSet.applyTo(new ChangeSet.AdapterInterface(){

            @Override
            public void notifyDataSetChanged() {
                ModularAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void notifyMove(int fromPosition, int toPosition) {
                ModularAdapter.this.notifyItemMoved(fromPosition, toPosition);
            }

            @Override
            public void notifyAdd(int index, int count) {
                ModularAdapter.this.notifyItemRangeInserted(index, count);
            }

            @Override
            public void notifyRemove(int index, int count) {
                ModularAdapter.this.notifyItemRangeRemoved(index, count);
            }

            @Override
            public void notifyChange(int index, int count) {
                ModularAdapter.this.notifyItemRangeChanged(index, count);
            }
        }));
    }

    public ItemManager<T> getItemManager() {
        return this.mItemManager;
    }

    public final ViewHolder<? extends T> onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.onCreateViewHolder(this.mInflater, parent, viewType);
    }

    @NonNull
    protected abstract ViewHolder<? extends T> onCreateViewHolder(@NonNull LayoutInflater var1, @NonNull ViewGroup var2, int var3);

    public final void onBindViewHolder(ViewHolder<? extends T> holder, int position) {
        T item = this.getItem(position);
        holder.bind(item);
    }

    public void onViewAttachedToWindow(ViewHolder<? extends T> holder) {
        super.onViewAttachedToWindow(holder);
        holder.onAttach();
    }

    public void onViewDetachedFromWindow(ViewHolder<? extends T> holder) {
        super.onViewDetachedFromWindow(holder);
        holder.onDetach();
    }

    public final int getItemCount() {
        return this.mItemManager.getItemCount();
    }

    @NonNull
    public final T getItem(int position) {
        return this.mItemManager.getItem(position);
    }

    public static class Builder<T> {
        private final List<ModularAdapterImpl.Module<?, ?>> mModules = new ArrayList();
        private final Context mContext;
        private final ItemManager<T> mItemManager;

        public Builder(@NonNull Context context, @NonNull ItemManager<T> itemManager) {
            this.mContext = context;
            this.mItemManager = itemManager;
        }

        public <M extends T, VH extends ViewHolder<M>> Builder<T> add(@NonNull Class<M> modelClass, @NonNull ViewHolderFactory<VH> holderFactory) {
            this.mModules.add(new ModularAdapterImpl.Module<M, VH>(this.mModules.size(), modelClass, holderFactory));
            return this;
        }

        public ModularAdapter<T> build() {
            return new ModularAdapterImpl<T>(this.mContext, this.mItemManager, this.mModules);
        }
    }

    public static interface ViewHolderFactory<VH extends ViewHolder<?>> {
        public VH create(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);
    }

    public static abstract class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        private T mCurrentItem;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
        }

        public final void bind(T item) {
            this.mCurrentItem = item;
            this.performBind(item);
        }

        protected abstract void performBind(@NonNull T var1);

        protected void onAttach() {
        }

        protected void onDetach() {
        }

        public final T getCurrentItem() {
            return this.mCurrentItem;
        }
    }
}

