/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.xw.repo.widget.R;

public class BounceScrollView
extends NestedScrollView {
    private static final float DEFAULT_DAMPING_COEFFICIENT = 4.0f;
    private static final int DEFAULT_SCROLL_THRESHOLD = 20;
    private static final long DEFAULT_BOUNCE_DELAY = 400L;
    private boolean isHorizontal;
    private float mDamping;
    private boolean mIncrementalDamping;
    private long mBounceDelay;
    private int mTriggerOverScrollThreshold;
    private boolean mDisableBounce;
    private Interpolator mInterpolator;
    private View mChildView;
    private float mStart;
    private int mPreDelta;
    private int mOverScrolledDistance;
    private ObjectAnimator mAnimator;
    private OnScrollListener mScrollListener;
    private OnOverScrollListener mOverScrollListener;

    public BounceScrollView(@NonNull Context context) {
        this(context, null);
    }

    public BounceScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BounceScrollView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BounceScrollView, 0, 0);
        this.mDamping = a.getFloat(R.styleable.BounceScrollView_damping, 4.0f);
        int orientation = a.getInt(R.styleable.BounceScrollView_scrollOrientation, 0);
        this.isHorizontal = orientation == 1;
        this.mIncrementalDamping = a.getBoolean(R.styleable.BounceScrollView_incrementalDamping, true);
        this.mBounceDelay = a.getInt(R.styleable.BounceScrollView_bounceDelay, 400);
        this.mTriggerOverScrollThreshold = a.getInt(R.styleable.BounceScrollView_triggerOverScrollThreshold, 20);
        this.mDisableBounce = a.getBoolean(R.styleable.BounceScrollView_disableBounce, false);
        boolean enable = a.getBoolean(R.styleable.BounceScrollView_nestedScrollingEnabled, true);
        a.recycle();
        this.setNestedScrollingEnabled(enable);
        this.mInterpolator = new DefaultQuartOutInterpolator();
    }

    public boolean canScrollVertically(int direction) {
        return !this.isHorizontal;
    }

    public boolean canScrollHorizontally(int direction) {
        return this.isHorizontal;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mChildView == null && this.getChildCount() > 0 || this.mChildView != this.getChildAt(0)) {
            this.mChildView = this.getChildAt(0);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mChildView == null || this.mDisableBounce) {
            return super.onTouchEvent(ev);
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mStart = this.isHorizontal ? ev.getX() : ev.getY();
                break;
            }
            case 2: {
                float now = this.isHorizontal ? ev.getX() : ev.getY();
                float delta = this.mStart - now;
                int dampingDelta = (int)(delta / this.calculateDamping());
                this.mStart = now;
                boolean onePointerTouch = true;
                if (this.mPreDelta <= 0 && dampingDelta > 0) {
                    onePointerTouch = false;
                } else if (this.mPreDelta >= 0 && dampingDelta < 0) {
                    onePointerTouch = false;
                }
                this.mPreDelta = dampingDelta;
                if (!onePointerTouch || !this.canMove(dampingDelta)) break;
                this.mOverScrolledDistance += dampingDelta;
                if (this.isHorizontal) {
                    this.mChildView.setTranslationX((float)(-this.mOverScrolledDistance));
                } else {
                    this.mChildView.setTranslationY((float)(-this.mOverScrolledDistance));
                }
                if (this.mOverScrollListener == null) break;
                this.mOverScrollListener.onOverScrolling(this.mOverScrolledDistance <= 0, Math.abs(this.mOverScrolledDistance));
                break;
            }
            case 1: 
            case 3: {
                this.mPreDelta = 0;
                this.mOverScrolledDistance = 0;
                this.cancelAnimator();
                this.mAnimator = this.isHorizontal ? ObjectAnimator.ofFloat((Object)this.mChildView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f}) : ObjectAnimator.ofFloat((Object)this.mChildView, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f});
                this.mAnimator.setDuration(this.mBounceDelay).setInterpolator((TimeInterpolator)this.mInterpolator);
                if (this.mOverScrollListener != null) {
                    this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float value = ((Float)animation.getAnimatedValue()).floatValue();
                            BounceScrollView.this.mOverScrollListener.onOverScrolling(value <= 0.0f, Math.abs((int)value));
                        }
                    });
                }
                this.mAnimator.start();
            }
        }
        return super.onTouchEvent(ev);
    }

    private float calculateDamping() {
        float ratio = this.isHorizontal ? Math.abs(this.mChildView.getTranslationX()) * 1.0f / (float)this.mChildView.getMeasuredWidth() : Math.abs(this.mChildView.getTranslationY()) * 1.0f / (float)this.mChildView.getMeasuredHeight();
        ratio = (float)((double)ratio + 0.2);
        if (this.mIncrementalDamping) {
            return this.mDamping / (1.0f - (float)Math.pow(ratio, 2.0));
        }
        return this.mDamping;
    }

    private boolean canMove(int delta) {
        return delta < 0 ? this.canMoveFromStart() : this.canMoveFromEnd();
    }

    private boolean canMoveFromStart() {
        return this.isHorizontal ? this.getScrollX() == 0 : this.getScrollY() == 0;
    }

    private boolean canMoveFromEnd() {
        if (this.isHorizontal) {
            int offset = this.mChildView.getMeasuredWidth() - this.getWidth();
            offset = offset < 0 ? 0 : offset;
            return this.getScrollX() == offset;
        }
        int offset = this.mChildView.getMeasuredHeight() - this.getHeight();
        offset = offset < 0 ? 0 : offset;
        return this.getScrollY() == offset;
    }

    private void cancelAnimator() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
    }

    protected void onScrollChanged(int scrollX, int scrollY, int oldl, int oldt) {
        super.onScrollChanged(scrollX, scrollY, oldl, oldt);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolling(scrollX, scrollY);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelAnimator();
    }

    public void setScrollHorizontally(boolean horizontal) {
        this.isHorizontal = horizontal;
    }

    public boolean isScrollHorizontally() {
        return this.isHorizontal;
    }

    public float getDamping() {
        return this.mDamping;
    }

    public void setDamping(@FloatRange(from=0.0, to=100.0) float damping) {
        if (this.mDamping > 0.0f) {
            this.mDamping = damping;
        }
    }

    public long getBounceDelay() {
        return this.mBounceDelay;
    }

    public void setBounceDelay(long bounceDelay) {
        if (bounceDelay >= 0L) {
            this.mBounceDelay = bounceDelay;
        }
    }

    public void setIncrementalDamping(boolean incrementalDamping) {
        this.mIncrementalDamping = incrementalDamping;
    }

    public boolean isIncrementalDamping() {
        return this.mIncrementalDamping;
    }

    public boolean isDisableBounce() {
        return this.mDisableBounce;
    }

    public void setDisableBounce(boolean disable) {
        this.mDisableBounce = disable;
    }

    public void setBounceInterpolator(@NonNull Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public int getTriggerOverScrollThreshold() {
        return this.mTriggerOverScrollThreshold;
    }

    public void setTriggerOverScrollThreshold(int threshold) {
        if (threshold >= 0) {
            this.mTriggerOverScrollThreshold = threshold;
        }
    }

    public void setOnScrollListener(OnScrollListener scrollListener) {
        this.mScrollListener = scrollListener;
    }

    public void setOnOverScrollListener(OnOverScrollListener overScrollListener) {
        this.mOverScrollListener = overScrollListener;
    }

    public static interface OnOverScrollListener {
        public void onOverScrolling(boolean var1, int var2);
    }

    public static interface OnScrollListener {
        public void onScrolling(int var1, int var2);
    }

    private static class DefaultQuartOutInterpolator
    implements Interpolator {
        private DefaultQuartOutInterpolator() {
        }

        public float getInterpolation(float input) {
            return (float)(1.0 - Math.pow(1.0f - input, 4.0));
        }
    }
}

