/*
 * Decompiled with CFR 0.152.
 */
package com.xw.repo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.xw.repo.widget.R;

public class BounceScrollView
extends NestedScrollView {
    private static final float DEFAULT_DAMPING_COEFFICIENT = 4.0f;
    private static final int DEFAULT_SCROLL_THRESHOLD = 20;
    private static final long DEFAULT_BOUNCE_DELAY = 400L;
    private boolean isHorizontal;
    private float mDamping;
    private boolean mIncrementalDamping;
    private long mBounceDelay;
    private int mTriggerOverScrollThreshold;
    private Interpolator mInterpolator;
    private View mChildView;
    private float mStart;
    private int mPreDelta;
    private int mOverScrolledDistance;
    private Rect mNormalRect = new Rect();
    private OnScrollListener mScrollListener;
    private OnOverScrollListener mOverScrollListener;

    public BounceScrollView(@NonNull Context context) {
        this(context, null);
    }

    public BounceScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BounceScrollView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOverScrollMode(2);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setFillViewport(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BounceScrollView, 0, 0);
        this.mDamping = a.getFloat(R.styleable.BounceScrollView_damping, 4.0f);
        int orientation = a.getInt(R.styleable.BounceScrollView_scrollOrientation, 0);
        this.isHorizontal = orientation == 1;
        this.mIncrementalDamping = a.getBoolean(R.styleable.BounceScrollView_incrementalDamping, true);
        this.mBounceDelay = a.getInt(R.styleable.BounceScrollView_bounceDelay, 400);
        this.mTriggerOverScrollThreshold = a.getInt(R.styleable.BounceScrollView_triggerOverScrollThreshold, 20);
        a.recycle();
        if (this.mIncrementalDamping) {
            this.mInterpolator = new DefaultQuartOutInterpolator();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 0) {
            this.mChildView = this.getChildAt(0);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int childMeasuredHeight = child.getMeasuredHeight();
            if (childMeasuredHeight <= 0) {
                return;
            }
            int childMeasuredWidth = child.getMeasuredWidth();
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                int marginStart = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)lp));
                int topMargin = ((ViewGroup.MarginLayoutParams)lp).topMargin;
                int marginEnd = MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)lp));
                int bottomMargin = ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
                if (marginStart != 0 || topMargin != 0 || marginEnd != 0 || bottomMargin != 0) {
                    if (childMeasuredHeight <= this.getMeasuredHeight()) {
                        childMeasuredWidth -= marginStart + marginEnd;
                        childMeasuredHeight -= topMargin + bottomMargin;
                    } else {
                        childMeasuredHeight += topMargin + bottomMargin;
                    }
                    int widthSpec = View.MeasureSpec.makeMeasureSpec((int)childMeasuredWidth, (int)0x40000000);
                    int heightSpec = View.MeasureSpec.makeMeasureSpec((int)childMeasuredHeight, (int)0x40000000);
                    child.measure(widthSpec, heightSpec);
                }
            }
        }
    }

    public boolean canScrollVertically(int direction) {
        return !this.isHorizontal;
    }

    public boolean canScrollHorizontally(int direction) {
        return this.isHorizontal;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mStart = this.isHorizontal ? ev.getX() : ev.getY();
                break;
            }
            case 2: {
                if (this.isHorizontal) {
                    float scrollX = ev.getX() - this.mStart;
                    return Math.abs(scrollX) >= (float)this.mTriggerOverScrollThreshold;
                }
                float scrollY = ev.getY() - this.mStart;
                return Math.abs(scrollY) >= (float)this.mTriggerOverScrollThreshold;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mChildView == null) {
            return super.onTouchEvent(ev);
        }
        switch (ev.getActionMasked()) {
            case 2: {
                float now = this.isHorizontal ? ev.getX() : ev.getY();
                float delta = this.mStart - now;
                int dampingDelta = (int)(delta / this.calculateDamping());
                this.mStart = now;
                boolean onePointerTouch = true;
                if (this.mPreDelta <= 0 && dampingDelta > 0) {
                    onePointerTouch = false;
                } else if (this.mPreDelta >= 0 && dampingDelta < 0) {
                    onePointerTouch = false;
                }
                this.mPreDelta = dampingDelta;
                if (!onePointerTouch || !this.canMove(dampingDelta)) break;
                if (this.mNormalRect.isEmpty()) {
                    this.mNormalRect.set(this.mChildView.getLeft(), this.mChildView.getTop(), this.mChildView.getRight(), this.mChildView.getBottom());
                }
                if (this.isHorizontal) {
                    this.mChildView.layout(this.mChildView.getLeft() - dampingDelta, this.mChildView.getTop(), this.mChildView.getRight() - dampingDelta, this.mChildView.getBottom());
                } else {
                    this.mChildView.layout(this.mChildView.getLeft(), this.mChildView.getTop() - dampingDelta, this.mChildView.getRight(), this.mChildView.getBottom() - dampingDelta);
                }
                if (this.mOverScrollListener == null) break;
                this.mOverScrolledDistance += dampingDelta;
                this.mOverScrollListener.onOverScrolling(this.mOverScrolledDistance <= 0, Math.abs(this.mOverScrolledDistance));
                break;
            }
            case 1: {
                this.performClick();
            }
            case 3: {
                if (!this.mNormalRect.isEmpty()) {
                    this.resetChildViewWithAnimation();
                }
                this.mPreDelta = 0;
                this.mOverScrolledDistance = 0;
            }
        }
        return super.onTouchEvent(ev);
    }

    private float calculateDamping() {
        float ratio = this.isHorizontal ? (float)Math.abs(this.mChildView.getLeft()) * 1.0f / (float)this.mChildView.getMeasuredWidth() : (float)Math.abs(this.mChildView.getTop()) * 1.0f / (float)this.mChildView.getMeasuredHeight();
        ratio = (float)((double)ratio + 0.2);
        if (this.mIncrementalDamping) {
            return this.mDamping / (1.0f - (float)Math.pow(ratio, 2.0));
        }
        return this.mDamping;
    }

    private void resetChildViewWithAnimation() {
        TranslateAnimation anim;
        ViewGroup.LayoutParams layoutParams = this.mChildView.getLayoutParams();
        int fixedMargin = 0;
        if (this.isHorizontal) {
            int fixedPadding;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                fixedPadding = ViewCompat.getPaddingEnd((View)this);
                if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                    fixedMargin = MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                }
            } else {
                fixedPadding = ViewCompat.getPaddingStart((View)this);
                if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                    fixedMargin = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)layoutParams));
                }
            }
            anim = new TranslateAnimation((float)(this.mChildView.getLeft() - fixedPadding - fixedMargin), (float)(this.mNormalRect.left - fixedPadding - fixedMargin), 0.0f, 0.0f);
        } else {
            int fixedPadding = this.getPaddingTop();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                fixedMargin = ((ViewGroup.MarginLayoutParams)layoutParams).topMargin;
            }
            anim = new TranslateAnimation(0.0f, 0.0f, (float)(this.mChildView.getTop() - fixedPadding - fixedMargin), (float)(this.mNormalRect.top - fixedPadding - fixedMargin));
        }
        anim.setInterpolator(this.mInterpolator);
        anim.setDuration(this.mBounceDelay);
        this.mChildView.startAnimation((Animation)anim);
        this.mChildView.layout(this.mNormalRect.left, this.mNormalRect.top, this.mNormalRect.right, this.mNormalRect.bottom);
        this.mNormalRect.setEmpty();
    }

    private boolean canMove(int delta) {
        return delta != 0 && delta < 0 ? this.canMoveFromStart() : this.canMoveFromEnd();
    }

    private boolean canMoveFromStart() {
        return this.isHorizontal ? this.getScrollX() == 0 : this.getScrollY() == 0;
    }

    private boolean canMoveFromEnd() {
        if (this.isHorizontal) {
            int offset = this.mChildView.getMeasuredWidth() - this.getWidth();
            offset = offset < 0 ? 0 : offset;
            return this.getScrollX() == offset;
        }
        int offset = this.mChildView.getMeasuredHeight() - this.getHeight();
        offset = offset < 0 ? 0 : offset;
        return this.getScrollY() == offset;
    }

    protected void onScrollChanged(int scrollX, int scrollY, int oldl, int oldt) {
        super.onScrollChanged(scrollX, scrollY, oldl, oldt);
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrolling(scrollX, scrollY);
        }
    }

    public void setScrollHorizontally(boolean horizontal) {
        this.isHorizontal = horizontal;
    }

    public boolean isScrollHorizontally() {
        return this.isHorizontal;
    }

    public float getDamping() {
        return this.mDamping;
    }

    public void setDamping(@FloatRange(from=0.0, to=100.0) float damping) {
        if (this.mDamping > 0.0f) {
            this.mDamping = damping;
        }
    }

    public long getBounceDelay() {
        return this.mBounceDelay;
    }

    public void setBounceDelay(long bounceDelay) {
        if (bounceDelay >= 0L) {
            this.mBounceDelay = bounceDelay;
        }
    }

    public void setIncrementalDamping(boolean incrementalDamping) {
        this.mIncrementalDamping = incrementalDamping;
    }

    public boolean isIncrementalDamping() {
        return this.mIncrementalDamping;
    }

    public void setBounceInterpolator(@NonNull Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public int getTriggerOverScrollThreshold() {
        return this.mTriggerOverScrollThreshold;
    }

    public void setTriggerOverScrollThreshold(int threshold) {
        if (threshold >= 0) {
            this.mTriggerOverScrollThreshold = threshold;
        }
    }

    public void setOnScrollListener(OnScrollListener scrollListener) {
        this.mScrollListener = scrollListener;
    }

    public void setOnOverScrollListener(OnOverScrollListener overScrollListener) {
        this.mOverScrollListener = overScrollListener;
    }

    public static interface OnOverScrollListener {
        public void onOverScrolling(boolean var1, int var2);
    }

    public static interface OnScrollListener {
        public void onScrolling(int var1, int var2);
    }

    private static class DefaultQuartOutInterpolator
    implements Interpolator {
        private DefaultQuartOutInterpolator() {
        }

        public float getInterpolation(float input) {
            return (float)(1.0 - Math.pow(1.0f - input, 4.0));
        }
    }
}

