/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.glideloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.glideloader.extensions.BitmapExtensionKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/wordpress/aztec/glideloader/GlideImageLoader;", "Lorg/wordpress/aztec/Html$ImageGetter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "loadImage", "", "source", "", "callbacks", "Lorg/wordpress/aztec/Html$ImageGetter$Callbacks;", "maxWidth", "", "minWidth", "glide-loader_release"})
public final class GlideImageLoader
implements Html.ImageGetter {
    private final Context context;

    public void loadImage(@NotNull String source, @NotNull Html.ImageGetter.Callbacks callbacks, int maxWidth) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        this.loadImage(source, callbacks, maxWidth, 0);
    }

    public void loadImage(@NotNull String source, @NotNull Html.ImageGetter.Callbacks callbacks, int maxWidth, int minWidth) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)callbacks, (String)"callbacks");
        Glide.with((Context)this.context).load(source).asBitmap().into((Target)new Target<Bitmap>(this, callbacks, minWidth, maxWidth){
            final /* synthetic */ GlideImageLoader this$0;
            final /* synthetic */ Html.ImageGetter.Callbacks $callbacks;
            final /* synthetic */ int $minWidth;
            final /* synthetic */ int $maxWidth;

            public void onLoadStarted(@Nullable Drawable placeholder) {
                this.$callbacks.onImageLoading(placeholder);
            }

            public void onLoadFailed(@Nullable Exception e, @Nullable Drawable errorDrawable) {
                this.$callbacks.onImageFailed();
            }

            public void onResourceReady(@Nullable Bitmap resource, @Nullable GlideAnimation<? super Bitmap> glideAnimation) {
                if (resource != null && resource.getWidth() < this.$minWidth) {
                    this.$callbacks.onImageLoaded((Drawable)new BitmapDrawable(GlideImageLoader.access$getContext$p(this.this$0).getResources(), BitmapExtensionKt.upscaleTo(resource, this.$minWidth)));
                    return;
                }
                Bitmap bitmap = resource;
                if (bitmap != null) {
                    bitmap.setDensity(160);
                }
                this.$callbacks.onImageLoaded((Drawable)new BitmapDrawable(GlideImageLoader.access$getContext$p(this.this$0).getResources(), resource));
            }

            public void onLoadCleared(@Nullable Drawable placeholder) {
            }

            public void getSize(@Nullable SizeReadyCallback cb) {
                block0: {
                    SizeReadyCallback sizeReadyCallback = cb;
                    if (sizeReadyCallback == null) break block0;
                    sizeReadyCallback.onSizeReady(this.$maxWidth, Integer.MIN_VALUE);
                }
            }

            public void setRequest(@Nullable Request request) {
            }

            @Nullable
            public Request getRequest() {
                return null;
            }

            public void onStart() {
            }

            public void onStop() {
            }

            public void onDestroy() {
            }
            {
                this.this$0 = $outer;
                this.$callbacks = $captured_local_variable$1;
                this.$minWidth = $captured_local_variable$2;
                this.$maxWidth = $captured_local_variable$3;
            }
        });
    }

    public GlideImageLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(GlideImageLoader $this) {
        return $this.context;
    }
}

