/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.handlers;

import android.text.Spannable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AlignmentRendering;
import org.wordpress.aztec.handlers.BlockHandler;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecListItemSpanKt;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.util.SpanWrapper;
import org.wordpress.aztec.watchers.TextDeleter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/wordpress/aztec/handlers/ListItemHandler;", "Lorg/wordpress/aztec/handlers/BlockHandler;", "Lorg/wordpress/aztec/spans/AztecListItemSpan;", "alignmentRendering", "Lorg/wordpress/aztec/AlignmentRendering;", "(Lorg/wordpress/aztec/AlignmentRendering;)V", "getAlignmentRendering", "()Lorg/wordpress/aztec/AlignmentRendering;", "handleEndOfBufferMarker", "", "handleNewlineAtEmptyBody", "handleNewlineAtEmptyLineAtBlockEnd", "handleNewlineAtStartOfBlock", "handleNewlineInBody", "Companion", "aztec_release"})
public final class ListItemHandler
extends BlockHandler<AztecListItemSpan> {
    @NotNull
    private final AlignmentRendering alignmentRendering;
    public static final Companion Companion = new Companion(null);

    @Override
    public void handleNewlineAtStartOfBlock() {
        Companion.newListItem(this.getText(), this.getNewlineIndex(), this.getNewlineIndex() + 1, ((AztecListItemSpan)this.getBlock().getSpan()).getNestingLevel(), this.alignmentRendering);
        this.getBlock().setStart(this.getNewlineIndex() + 1);
    }

    @Override
    public void handleNewlineAtEmptyLineAtBlockEnd() {
        SpanWrapper<? extends IAztecNestable> parent = IAztecNestable.Companion.getParent(this.getText(), this.getBlock());
        if (parent == null || parent.getEnd() == 0 && parent.getStart() == 0) {
            this.getBlock().remove();
            return;
        }
        if (this.getBlock().getEnd() == parent.getEnd()) {
            this.getBlock().remove();
        }
    }

    @Override
    public void handleNewlineAtEmptyBody() {
        this.getBlock().remove();
    }

    @Override
    public void handleNewlineInBody() {
        int newListItemStart = this.getNewlineIndex() + 1;
        if (TextDeleter.Companion.isMarkedForDeletion(this.getText(), this.getNewlineIndex(), this.getNewlineIndex() + 1)) {
            newListItemStart = this.getNewlineIndex();
        }
        Companion.newListItem(this.getText(), newListItemStart, this.getBlock().getEnd(), ((AztecListItemSpan)this.getBlock().getSpan()).getNestingLevel(), this.alignmentRendering);
        this.getBlock().setEnd(newListItemStart);
    }

    @Override
    public void handleEndOfBufferMarker() {
        if (this.getBlock().getStart() == this.getMarkerIndex()) {
            return;
        }
        Companion.newListItem(this.getText(), this.getMarkerIndex(), this.getMarkerIndex() + 1, ((AztecListItemSpan)this.getBlock().getSpan()).getNestingLevel(), this.alignmentRendering);
        this.getBlock().setEnd(this.getMarkerIndex());
    }

    @NotNull
    public final AlignmentRendering getAlignmentRendering() {
        return this.alignmentRendering;
    }

    public ListItemHandler(@NotNull AlignmentRendering alignmentRendering) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)alignmentRendering), (String)"alignmentRendering");
        super(AztecListItemSpan.class);
        this.alignmentRendering = alignmentRendering;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/wordpress/aztec/handlers/ListItemHandler$Companion;", "", "()V", "newListItem", "", "text", "Landroid/text/Spannable;", "start", "", "end", "nestingLevel", "alignmentRendering", "Lorg/wordpress/aztec/AlignmentRendering;", "aztec_release"})
    public static final class Companion {
        public final void newListItem(@NotNull Spannable text, int start, int end, int nestingLevel, @NotNull AlignmentRendering alignmentRendering) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)((Object)alignmentRendering), (String)"alignmentRendering");
            BlockHandler.Companion.set(text, AztecListItemSpanKt.createListItemSpan$default(nestingLevel, alignmentRendering, null, 4, null), start, end);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

