/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.os.Build;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.EditText;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.R;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/wordpress/aztec/AztecTextAccessibilityDelegate;", "", "aztecText", "Landroid/widget/EditText;", "(Landroid/widget/EditText;)V", "ACCESSIBILITY_INVALID_LINE_ID", "", "accessibilityManager", "Landroid/view/accessibility/AccessibilityManager;", "cursorMovedText", "", "kotlin.jvm.PlatformType", "lastLineAnnouncedForAccessibilityOffset", "mediaItemContentDescription", "announceForAccessibility", "", "event", "Landroid/view/MotionEvent;", "announceLine", "", "lineOffset", "getLineOffset", "x", "", "y", "getTextAtLine", "isLineBlank", "moveCursor", "onHoverEvent", "resetLastLineAnnouncedForAccessibilityOffset", "aztec_release"})
public final class AztecTextAccessibilityDelegate {
    private final int ACCESSIBILITY_INVALID_LINE_ID = -1;
    private final String mediaItemContentDescription;
    private final String cursorMovedText;
    private final AccessibilityManager accessibilityManager;
    private int lastLineAnnouncedForAccessibilityOffset;
    private final EditText aztecText;

    public final boolean onHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.accessibilityManager.isEnabled() || !this.accessibilityManager.isTouchExplorationEnabled()) {
            return false;
        }
        if (event.getAction() == 9) {
            this.resetLastLineAnnouncedForAccessibilityOffset();
        }
        if (event.getAction() == 10) {
            this.moveCursor(event.getX(), event.getY());
        }
        return this.announceForAccessibility(event);
    }

    private final void resetLastLineAnnouncedForAccessibilityOffset() {
        this.lastLineAnnouncedForAccessibilityOffset = this.ACCESSIBILITY_INVALID_LINE_ID;
    }

    private final void moveCursor(float x, float y) {
        Selection.removeSelection((Spannable)((Spannable)this.aztecText.getText()));
        this.aztecText.announceForAccessibility((CharSequence)this.cursorMovedText);
        Selection.setSelection((Spannable)((Spannable)this.aztecText.getText()), (int)this.aztecText.getOffsetForPosition(x, y));
    }

    private final boolean announceForAccessibility(MotionEvent event) {
        int lineOffset = this.getLineOffset(event.getX(), event.getY());
        if (lineOffset != this.ACCESSIBILITY_INVALID_LINE_ID && this.lastLineAnnouncedForAccessibilityOffset != lineOffset) {
            this.announceLine(lineOffset);
        }
        return lineOffset != this.ACCESSIBILITY_INVALID_LINE_ID;
    }

    private final void announceLine(int lineOffset) {
        if (!this.aztecText.isFocused() || Build.VERSION.SDK_INT >= 21 && !this.aztecText.isAccessibilityFocused()) {
            this.aztecText.sendAccessibilityEvent(8);
            this.aztecText.requestFocus();
        } else {
            String string2 = this.getTextAtLine(lineOffset);
            String string3 = Constants.INSTANCE.getIMG_STRING();
            String string4 = this.mediaItemContentDescription;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mediaItemContentDescription");
            String announcement = StringsKt.replace$default((String)string2, (String)string3, (String)string4, (boolean)false, (int)4, null);
            this.accessibilityManager.interrupt();
            this.aztecText.announceForAccessibility((CharSequence)announcement);
        }
        this.lastLineAnnouncedForAccessibilityOffset = lineOffset;
    }

    private final int getLineOffset(float x, float y) {
        int charPos = this.aztecText.getOffsetForPosition(x, y);
        int lineOffset = this.ACCESSIBILITY_INVALID_LINE_ID;
        if (charPos != -1 && this.isLineBlank(lineOffset = this.aztecText.getLayout().getLineForOffset(charPos))) {
            lineOffset = this.ACCESSIBILITY_INVALID_LINE_ID;
        }
        return lineOffset;
    }

    private final String getTextAtLine(int lineOffset) {
        int lineStartOffset = this.aztecText.getLayout().getLineStart(lineOffset);
        int lineEndOffset = this.aztecText.getLayout().getLineEnd(lineOffset);
        Editable editable = this.aztecText.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"aztecText.text");
        CharSequence charSequence = (CharSequence)editable;
        return ((Object)charSequence.subSequence(lineStartOffset, lineEndOffset)).toString();
    }

    private final boolean isLineBlank(int lineOffset) {
        return StringUtils.isBlank((CharSequence)StringsKt.replace$default((String)this.getTextAtLine(lineOffset), (String)Constants.INSTANCE.getMAGIC_STRING(), (String)"", (boolean)false, (int)4, null));
    }

    public AztecTextAccessibilityDelegate(@NotNull EditText aztecText) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.aztecText = aztecText;
        this.ACCESSIBILITY_INVALID_LINE_ID = -1;
        this.mediaItemContentDescription = this.aztecText.getContext().getString(R.string.media_item_content_description);
        this.cursorMovedText = this.aztecText.getContext().getString(R.string.cursor_moved);
        Object object = this.aztecText.getContext().getSystemService("accessibility");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        }
        this.accessibilityManager = (AccessibilityManager)object;
        this.lastLineAnnouncedForAccessibilityOffset = this.ACCESSIBILITY_INVALID_LINE_ID;
    }
}

