/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.ime;

import android.os.Build;
import android.view.inputmethod.EditorInfo;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/ime/EditorInfoUtils;", "", "()V", "areEditorInfosTheSame", "", "ed1", "Landroid/view/inputmethod/EditorInfo;", "ed2", "copyEditorInfo", "aztec_release"})
public final class EditorInfoUtils {
    public static final EditorInfoUtils INSTANCE;

    @JvmStatic
    public static final boolean areEditorInfosTheSame(@NotNull EditorInfo ed1, @NotNull EditorInfo ed2) {
        Intrinsics.checkParameterIsNotNull((Object)ed1, (String)"ed1");
        Intrinsics.checkParameterIsNotNull((Object)ed2, (String)"ed2");
        if (Intrinsics.areEqual((Object)ed1, (Object)ed2)) {
            return true;
        }
        if (ed1.actionId == ed2.actionId && (ed1.actionLabel != null && ed1.actionLabel.equals(ed2.actionLabel) || ed1.actionLabel == null && ed2.actionLabel == null) && ed1.inputType == ed2.inputType && ed1.imeOptions == ed2.imeOptions && (ed1.privateImeOptions != null && ed1.privateImeOptions.equals(ed2.privateImeOptions) || ed1.privateImeOptions == null && ed2.privateImeOptions == null) && ed1.initialSelStart == ed2.initialSelStart && ed1.initialSelEnd == ed2.initialSelEnd && ed1.initialCapsMode == ed2.initialCapsMode && ed1.fieldId == ed2.fieldId) {
            if (Build.VERSION.SDK_INT >= 25 && ed1.contentMimeTypes != null && ed2.contentMimeTypes != null) {
                return Arrays.equals(ed1.contentMimeTypes, ed2.contentMimeTypes);
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final EditorInfo copyEditorInfo(@NotNull EditorInfo ed1) {
        Intrinsics.checkParameterIsNotNull((Object)ed1, (String)"ed1");
        EditorInfo copy = new EditorInfo();
        copy.actionId = ed1.actionId;
        CharSequence charSequence = ed1.actionLabel;
        copy.actionLabel = charSequence != null ? ((Object)charSequence).toString() : null;
        copy.inputType = ed1.inputType;
        copy.imeOptions = ed1.imeOptions;
        String string2 = ed1.privateImeOptions;
        copy.privateImeOptions = string2 != null ? string2.toString() : null;
        copy.initialSelStart = ed1.initialSelStart;
        copy.initialSelEnd = ed1.initialSelEnd;
        copy.initialCapsMode = ed1.initialCapsMode;
        copy.fieldId = ed1.fieldId;
        if (Build.VERSION.SDK_INT >= 25 && ed1.contentMimeTypes != null) {
            copy.contentMimeTypes = Arrays.copyOf(ed1.contentMimeTypes, ed1.contentMimeTypes.length);
        }
        return copy;
    }

    private EditorInfoUtils() {
    }

    static {
        EditorInfoUtils editorInfoUtils;
        INSTANCE = editorInfoUtils = new EditorInfoUtils();
    }
}

