/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.R;
import org.wordpress.aztec.plugins.IAztecPlugin;
import org.wordpress.aztec.plugins.html2visual.IHtmlTagHandler;
import org.wordpress.aztec.spans.AztecAudioSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecHorizontalRuleSpan;
import org.wordpress.aztec.spans.AztecImageSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecOrderedListSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.spans.AztecQuoteSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecUnorderedListSpan;
import org.wordpress.aztec.spans.AztecVideoSpan;
import org.wordpress.aztec.spans.HiddenHtmlBlock;
import org.wordpress.aztec.spans.HiddenHtmlSpan;
import org.wordpress.aztec.spans.IAztecAttributedSpan;
import org.wordpress.aztec.spans.IAztecNestable;
import org.wordpress.aztec.spans.ParagraphSpan;
import org.wordpress.aztec.util.ExtensionsKt;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lorg/wordpress/aztec/AztecTagHandler;", "Lorg/wordpress/aztec/Html$TagHandler;", "context", "Landroid/content/Context;", "plugins", "", "Lorg/wordpress/aztec/plugins/IAztecPlugin;", "(Landroid/content/Context;Ljava/util/List;)V", "getContext", "()Landroid/content/Context;", "loadingDrawable", "Landroid/graphics/drawable/Drawable;", "getPlugins", "()Ljava/util/List;", "end", "", "output", "Landroid/text/Editable;", "kind", "Ljava/lang/Class;", "handleElement", "opening", "", "span", "", "handleMediaElement", "mediaSpan", "Lorg/wordpress/aztec/spans/AztecMediaSpan;", "handleTag", "tag", "", "attributes", "Lorg/xml/sax/Attributes;", "nestingLevel", "", "processTagHandlerPlugins", "start", "mark", "Companion", "aztec_release"})
public final class AztecTagHandler
implements Html.TagHandler {
    private final Drawable loadingDrawable;
    @NotNull
    private final Context context;
    @NotNull
    private final List<IAztecPlugin> plugins;
    private static final String LIST_LI = "li";
    private static final String LIST_UL = "ul";
    private static final String LIST_OL = "ol";
    private static final String STRIKETHROUGH_S = "s";
    private static final String STRIKETHROUGH_STRIKE = "strike";
    private static final String STRIKETHROUGH_DEL = "del";
    private static final String DIV = "div";
    private static final String SPAN = "span";
    private static final String FIGURE = "figure";
    private static final String FIGCAPTION = "figcaption";
    private static final String SECTION = "section";
    private static final String BLOCKQUOTE = "blockquote";
    private static final String PARAGRAPH = "p";
    private static final String PREFORMAT = "pre";
    private static final String IMAGE = "img";
    private static final String VIDEO = "video";
    private static final String AUDIO = "audio";
    private static final String LINE = "hr";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handleTag(boolean opening, @NotNull String tag, @NotNull Editable output, @NotNull Context context, @NotNull Attributes attributes, int nestingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        boolean wasTagHandled = this.processTagHandlerPlugins(tag, opening, output, attributes, nestingLevel);
        if (wasTagHandled) {
            return true;
        }
        String string = tag;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)LIST_LI)) {
            this.handleElement(output, opening, new AztecListItemSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)STRIKETHROUGH_S) || Intrinsics.areEqual((Object)string3, (Object)STRIKETHROUGH_STRIKE) || Intrinsics.areEqual((Object)string3, (Object)STRIKETHROUGH_DEL)) {
            this.handleElement(output, opening, new AztecStrikethroughSpan(tag, new AztecAttributes(attributes)));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)SPAN)) {
            this.handleElement(output, opening, new HiddenHtmlSpan(tag, new AztecAttributes(attributes), nestingLevel));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)DIV) || Intrinsics.areEqual((Object)string3, (Object)FIGURE) || Intrinsics.areEqual((Object)string3, (Object)FIGCAPTION) || Intrinsics.areEqual((Object)string3, (Object)SECTION)) {
            this.handleElement(output, opening, new HiddenHtmlBlock(tag, new AztecAttributes(attributes), nestingLevel));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)LIST_UL)) {
            this.handleElement(output, opening, new AztecUnorderedListSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)LIST_OL)) {
            this.handleElement(output, opening, new AztecOrderedListSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)BLOCKQUOTE)) {
            this.handleElement(output, opening, new AztecQuoteSpan(nestingLevel, new AztecAttributes(attributes), null, null, 12, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)IMAGE)) {
            this.handleMediaElement(opening, output, new AztecImageSpan(context, this.loadingDrawable, nestingLevel, new AztecAttributes(attributes), null, null, null, 112, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)VIDEO)) {
            if (opening) {
                this.handleMediaElement(true, output, new AztecVideoSpan(context, this.loadingDrawable, nestingLevel, new AztecAttributes(attributes), null, null, null, 112, null));
                this.handleMediaElement(false, output, new AztecVideoSpan(context, this.loadingDrawable, nestingLevel, new AztecAttributes(attributes), null, null, null, 112, null));
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)AUDIO)) {
            if (opening) {
                this.handleMediaElement(true, output, new AztecAudioSpan(context, this.loadingDrawable, nestingLevel, new AztecAttributes(attributes), null, null, null, 112, null));
                this.handleMediaElement(false, output, new AztecAudioSpan(context, this.loadingDrawable, nestingLevel, new AztecAttributes(attributes), null, null, null, 112, null));
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)PARAGRAPH)) {
            this.handleElement(output, opening, new ParagraphSpan(nestingLevel, new AztecAttributes(attributes), null, 4, null));
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)LINE)) {
            if (opening) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.img_hr);
                if (drawable2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026ext, R.drawable.img_hr)!!");
                this.start(output, new AztecHorizontalRuleSpan(context, drawable2, nestingLevel, new AztecAttributes(attributes), null, 16, null));
                output.append(Constants.INSTANCE.getMAGIC_CHAR());
            } else {
                this.end(output, AztecHorizontalRuleSpan.class);
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string3, (Object)PREFORMAT)) {
            this.handleElement(output, opening, new AztecPreformatSpan(nestingLevel, new AztecAttributes(attributes), null, null, 12, null));
            return true;
        }
        if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            this.handleElement(output, opening, new AztecHeadingSpan(nestingLevel, tag, new AztecAttributes(attributes), null, 8, null));
            return true;
        }
        return false;
    }

    private final boolean processTagHandlerPlugins(String tag, boolean opening, Editable output, Attributes attributes, int nestingLevel) {
        IAztecPlugin it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.plugins;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)element$iv$iv;
            if (!(it instanceof IHtmlTagHandler)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (IAztecPlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            IAztecPlugin iAztecPlugin = it;
            if (iAztecPlugin == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.plugins.html2visual.IHtmlTagHandler");
            }
            IHtmlTagHandler iHtmlTagHandler = (IHtmlTagHandler)iAztecPlugin;
            collection.add(iHtmlTagHandler);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            boolean wasHandled;
            IHtmlTagHandler it2 = (IHtmlTagHandler)element$iv;
            if (!it2.canHandleTag(tag) || !(wasHandled = it2.handleTag(opening, tag, output, attributes, nestingLevel))) continue;
            return true;
        }
        return false;
    }

    private final void handleMediaElement(boolean opening, Editable output, AztecMediaSpan mediaSpan) {
        if (opening) {
            this.start(output, mediaSpan);
            this.start(output, (Object)new AztecMediaClickableSpan(mediaSpan));
            output.append(Constants.INSTANCE.getIMG_CHAR());
        } else {
            this.end(output, mediaSpan.getClass());
            this.end(output, AztecMediaClickableSpan.class);
        }
    }

    private final void handleElement(Editable output, boolean opening, Object span) {
        if (opening) {
            this.start(output, span);
        } else {
            this.end(output, span.getClass());
        }
    }

    private final void start(Editable output, Object mark) {
        output.setSpan(mark, output.length(), output.length(), 17);
    }

    private final void end(Editable output, Class<?> kind) {
        int end;
        Object last = ExtensionsKt.getLast(output, kind);
        int start = output.getSpanStart(last);
        if (start != (end = output.length())) {
            output.setSpan(last, start, end, 33);
            if (last instanceof IAztecAttributedSpan) {
                ((IAztecAttributedSpan)last).applyInlineStyleAttributes(output, start, end);
            }
        } else if (start == end && IAztecNestable.class.isAssignableFrom(kind)) {
            if (HiddenHtmlSpan.class.isAssignableFrom(kind)) {
                output.append(Constants.INSTANCE.getMAGIC_CHAR());
            } else {
                output.append(Constants.INSTANCE.getZWJ_CHAR());
            }
            output.setSpan(last, start, output.length(), 33);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<IAztecPlugin> getPlugins() {
        return this.plugins;
    }

    public AztecTagHandler(@NotNull Context context, @NotNull List<? extends IAztecPlugin> plugins) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(plugins, (String)"plugins");
        this.context = context;
        this.plugins = plugins;
        TypedArray styles = this.context.obtainStyledAttributes(R.styleable.AztecText);
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.context, (int)styles.getResourceId(R.styleable.AztecText_drawableLoading, R.drawable.ic_image_loading));
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        this.loadingDrawable = drawable2;
        styles.recycle();
    }

    public /* synthetic */ AztecTagHandler(Context context, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(context, list);
    }

    static {
        LIST_LI = LIST_LI;
        LIST_UL = LIST_UL;
        LIST_OL = LIST_OL;
        STRIKETHROUGH_S = STRIKETHROUGH_S;
        STRIKETHROUGH_STRIKE = STRIKETHROUGH_STRIKE;
        STRIKETHROUGH_DEL = STRIKETHROUGH_DEL;
        DIV = DIV;
        SPAN = SPAN;
        FIGURE = FIGURE;
        FIGCAPTION = FIGCAPTION;
        SECTION = SECTION;
        BLOCKQUOTE = BLOCKQUOTE;
        PARAGRAPH = PARAGRAPH;
        PREFORMAT = PREFORMAT;
        IMAGE = IMAGE;
        VIDEO = VIDEO;
        AUDIO = AUDIO;
        LINE = LINE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/wordpress/aztec/AztecTagHandler$Companion;", "", "()V", "AUDIO", "", "BLOCKQUOTE", "DIV", "FIGCAPTION", "FIGURE", "IMAGE", "LINE", "LIST_LI", "LIST_OL", "LIST_UL", "PARAGRAPH", "PREFORMAT", "SECTION", "SPAN", "STRIKETHROUGH_DEL", "STRIKETHROUGH_S", "STRIKETHROUGH_STRIKE", "VIDEO", "aztec_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

