/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers.event.sequence.known.space;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.watchers.event.sequence.EventSequence;
import org.wordpress.aztec.watchers.event.sequence.UserOperationEvent;
import org.wordpress.aztec.watchers.event.sequence.known.space.steps.TextWatcherEventDeleteText;
import org.wordpress.aztec.watchers.event.sequence.known.space.steps.TextWatcherEventInsertText;
import org.wordpress.aztec.watchers.event.sequence.known.space.steps.TextWatcherEventInsertTextDelAfter;
import org.wordpress.aztec.watchers.event.text.AfterTextChangedEventData;
import org.wordpress.aztec.watchers.event.text.BeforeTextChangedEventData;
import org.wordpress.aztec.watchers.event.text.TextWatcherEvent;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/known/space/API26PrependNewLineOnStyledSpecialTextEvent;", "Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent;", "()V", "buildReplacementEventWithSequenceData", "Lorg/wordpress/aztec/watchers/event/text/TextWatcherEvent;", "sequence", "Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "isUserOperationObservedInSequence", "Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent$ObservedOperationResultType;", "aztec_release"})
public final class API26PrependNewLineOnStyledSpecialTextEvent
extends UserOperationEvent {
    @Override
    @NotNull
    public UserOperationEvent.ObservedOperationResultType isUserOperationObservedInSequence(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        if (this.getSequence().size() == sequence.size()) {
            if (!this.isUserOperationPartiallyObservedInSequence(sequence)) {
                return UserOperationEvent.ObservedOperationResultType.SEQUENCE_NOT_FOUND;
            }
            TextWatcherEvent firstEvent = (TextWatcherEvent)CollectionsKt.first((List)sequence);
            TextWatcherEvent lastEvent = (TextWatcherEvent)CollectionsKt.last((List)sequence);
            TextWatcherEvent midEvent = (TextWatcherEvent)sequence.get(1);
            SpannableStringBuilder spannableStringBuilder = firstEvent.getBeforeEventData().getTextBefore();
            if (spannableStringBuilder != null) {
                int n = spannableStringBuilder.length();
                Editable editable = lastEvent.getAfterEventData().getTextAfter();
                if (editable == null) {
                    Intrinsics.throwNpe();
                }
                if (n == editable.length()) {
                    SpannableStringBuilder spannableStringBuilder2 = midEvent.getOnEventData().getTextOn();
                    if (spannableStringBuilder2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (spannableStringBuilder2.charAt(midEvent.getOnEventData().getStart()) == Constants.INSTANCE.getNEWLINE()) {
                        return UserOperationEvent.ObservedOperationResultType.SEQUENCE_FOUND;
                    }
                }
            }
        }
        return UserOperationEvent.ObservedOperationResultType.SEQUENCE_NOT_FOUND;
    }

    @Override
    @NotNull
    public TextWatcherEvent buildReplacementEventWithSequenceData(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        TextWatcherEventInsertText.Builder builder = new TextWatcherEventInsertText.Builder();
        TextWatcherEvent firstEvent = (TextWatcherEvent)CollectionsKt.first((List)sequence);
        BeforeTextChangedEventData beforeTextChangedEventData = firstEvent.getBeforeEventData();
        SpannableStringBuilder oldText = beforeTextChangedEventData.component1();
        int indexWhereToInsertNewLine = firstEvent.getBeforeEventData().getStart();
        SpannableStringBuilder spannableStringBuilder = oldText;
        if (spannableStringBuilder != null) {
            spannableStringBuilder.insert(indexWhereToInsertNewLine, (CharSequence)Constants.INSTANCE.getNEWLINE_STRING());
        }
        builder.setAfterEventData(new AfterTextChangedEventData((Editable)oldText));
        TextWatcherEventInsertText replacementEvent = builder.build();
        replacementEvent.setInsertionStart(indexWhereToInsertNewLine);
        replacementEvent.setInsertionLength(1);
        return replacementEvent;
    }

    public API26PrependNewLineOnStyledSpecialTextEvent() {
        super(null, 1, null);
        TextWatcherEventDeleteText.Builder builder = new TextWatcherEventDeleteText.Builder();
        TextWatcherEventDeleteText step1 = builder.build();
        TextWatcherEventInsertTextDelAfter.Builder builderStep2 = new TextWatcherEventInsertTextDelAfter.Builder();
        TextWatcherEventInsertTextDelAfter step2 = builderStep2.build();
        TextWatcherEventInsertText.Builder builderStep3 = new TextWatcherEventInsertText.Builder();
        TextWatcherEventInsertText step3 = builderStep3.build();
        this.clear();
        this.addSequenceStep(step1);
        this.addSequenceStep(step2);
        this.addSequenceStep(step3);
    }
}

